/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.Repository;
import com.samskivert.jdbc.jora.Table;
import com.threerings.user.Log;
import com.threerings.user.ReferralRecord;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;

public class ReferralRepository
extends JORARepository {
    public static final String REFERRAL_DB_IDENT = "referraldb";
    protected Table<ReferralRecord> _rtable;
    protected boolean _active;
    protected long _lastPurge;
    protected static final long PURGE_INTERVAL = 10800000L;

    public ReferralRepository(ConnectionProvider provider) throws PersistenceException {
        super(provider, REFERRAL_DB_IDENT);
        this.execute((Repository.Operation)new Repository.Operation<Void>(){

            public Void invoke(Connection conn, DatabaseLiaison liaison) throws PersistenceException, SQLException {
                ReferralRepository.this._active = JDBCUtil.tableExists((Connection)conn, (String)"REFERRAL");
                if (!ReferralRepository.this._active) {
                    Log.log.info((Object)"No referral table. Disabling.", new Object[0]);
                }
                return null;
            }
        });
    }

    public int recordReferral(int referrerId, String data) throws PersistenceException {
        if (!this._active) {
            throw new PersistenceException("Referral repository is not available.");
        }
        ReferralRecord record = new ReferralRecord();
        record.recorded = new Date(System.currentTimeMillis());
        record.referrerId = referrerId;
        record.data = data;
        record.referralId = this.insert(this._rtable, record);
        this.checkPurge();
        return record.referralId;
    }

    public ReferralRecord lookupReferral(int referralId) throws PersistenceException {
        return this.lookupReferralBy("where REFERRAL_ID = " + referralId);
    }

    public ReferralRecord lookupReferrer(int referrerId) throws PersistenceException {
        return this.lookupReferralBy("where REFERRER_ID = " + referrerId);
    }

    protected ReferralRecord lookupReferralBy(String query) throws PersistenceException {
        if (!this._active) {
            return null;
        }
        ReferralRecord record = (ReferralRecord)this.load(this._rtable, query);
        this.checkPurge();
        return record;
    }

    protected void checkPurge() {
        long now = System.currentTimeMillis();
        if (now - this._lastPurge > 10800000L) {
            this._lastPurge = now;
            try {
                this.purgeStaleReferrals();
            }
            catch (PersistenceException pe) {
                Log.log.warning((Object)("Error purging referrals: " + (Object)((Object)pe)), new Object[0]);
            }
        }
    }

    protected void purgeStaleReferrals() throws PersistenceException {
        this.executeUpdate((Repository.Operation)new Repository.Operation<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void invoke(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
                String pquery = "delete from REFERRAL where DATE_SUB(NOW(), INTERVAL 1 MONTH) > RECORDED;";
                Statement stmt = conn.createStatement();
                try {
                    stmt.executeUpdate(pquery);
                }
                finally {
                    JDBCUtil.close((Statement)stmt);
                }
                return null;
            }
        });
    }

    protected void createTables() {
        this._rtable = new Table(ReferralRecord.class, "REFERRAL", "REFERRAL_ID", true);
    }
}

