/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.user;

import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.servlet.RedirectException;
import com.samskivert.servlet.user.User;
import com.samskivert.servlet.user.UserManager;
import com.samskivert.servlet.user.UserRepository;
import com.samskivert.util.RunQueue;
import com.threerings.user.GameBlastAuxRepository;
import com.threerings.user.Log;
import com.threerings.user.OOOUser;
import com.threerings.user.OOOUserRepository;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class OOOUserManager
extends UserManager {
    protected GameBlastAuxRepository _blastRepo;
    protected String _accessDeniedURL;

    public OOOUserManager(Properties config, ConnectionProvider conprov) throws PersistenceException {
        this(config, conprov, null);
    }

    public OOOUserManager(Properties config, ConnectionProvider conprov, RunQueue pruneQueue) throws PersistenceException {
        this.init(config, conprov, pruneQueue);
    }

    public OOOUserManager() {
    }

    public OOOUserRepository getRepository() {
        return (OOOUserRepository)this._repository;
    }

    public void init(Properties config, ConnectionProvider conprov, RunQueue pruneQueue) throws PersistenceException {
        super.init(config, conprov, pruneQueue);
        this._blastRepo = new GameBlastAuxRepository(conprov);
        this._accessDeniedURL = config.getProperty("access_denied_url");
        if (this._accessDeniedURL == null) {
            Log.log.warning((Object)"No 'access_denied_url' supplied in user manager config. Restricted pages will behave strangely.", new Object[0]);
        }
    }

    public GameBlastAuxRepository getBlastRepository() {
        return this._blastRepo;
    }

    public User requireUser(HttpServletRequest req, byte token) throws PersistenceException, RedirectException {
        OOOUser user = (OOOUser)this.requireUser(req);
        if (!user.holdsToken(token)) {
            throw new RedirectException(this._accessDeniedURL);
        }
        return user;
    }

    public User requireUser(HttpServletRequest req, byte[] tokens) throws PersistenceException, RedirectException {
        OOOUser user = (OOOUser)this.requireUser(req);
        if (!user.holdsAnyToken(tokens)) {
            throw new RedirectException(this._accessDeniedURL);
        }
        return user;
    }

    protected UserRepository createRepository(ConnectionProvider conprov) throws PersistenceException {
        return new OOOUserRepository(conprov);
    }
}

