/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server.persist;

import com.google.common.base.Preconditions;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.expression.SQLExpression;
import com.threerings.coin.server.CoinExOffer;
import com.threerings.coin.server.persist.CoinExOfferRecord;
import com.threerings.coin.server.persist.LastExPriceRecord;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;

public class CoinExchangeRepository
extends DepotRepository {
    protected String _serverId;

    public CoinExchangeRepository(PersistenceContext ctx, String serverId) {
        super(ctx);
        this._serverId = serverId;
    }

    public List<CoinExOffer> loadAll() {
        return this.map(this.findAll(CoinExOfferRecord.class, new QueryClause[]{new Where((SQLExpression)CoinExOfferRecord.SERVER_ID.eq((Comparable)((Object)this._serverId)))}), CoinExOfferRecord.TO_OFFER).toList();
    }

    public short getLastPrice() {
        LastExPriceRecord rec = (LastExPriceRecord)this.load(LastExPriceRecord.getKey(this._serverId), new QueryClause[0]);
        return rec == null ? (short)-1 : (short)rec.lastPrice;
    }

    public void setLastPrice(short price) {
        LastExPriceRecord rec = new LastExPriceRecord();
        rec.serverId = this._serverId;
        rec.lastPrice = price;
        this.store(rec);
    }

    public void insert(CoinExOffer newOffer) {
        Preconditions.checkArgument((newOffer.offerId == 0 ? 1 : 0) != 0, (Object)"A CoinExOffer's offerId must be 0 for insertion.");
        newOffer.serverId = this._serverId;
        newOffer.entered = new Timestamp(System.currentTimeMillis());
        CoinExOfferRecord record = new CoinExOfferRecord(newOffer);
        this.insert(record);
        newOffer.offerId = record.offerId;
    }

    public void update(CoinExOffer offer) {
        if (1 != this.update(new CoinExOfferRecord(offer))) {
            throw new DatabaseException("Update failed");
        }
    }

    public void remove(CoinExOffer offer) {
        if (1 != this.delete(CoinExOfferRecord.getKey(offer.offerId))) {
            throw new DatabaseException("Remove failed");
        }
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(CoinExOfferRecord.class);
        classes.add(LastExPriceRecord.class);
    }
}

