package com.hexnova.narya.util;

import java.util.Map;

import com.google.common.collect.Maps;
import com.google.protobuf.Message;

public class ProtocolMessageRegistry {
	static Map<Integer,Class<? extends Message>> typeMessage = Maps.newHashMap();
	static Map<Class<? extends Message>,Integer> messageType = Maps.newHashMap();
	
	private ProtocolMessageRegistry(){}
	
	public static void regist(int key ,Class<? extends Message> value) {
		typeMessage.put(key, value);
		messageType.put(value, key);
	}
	
	public static Class<? extends Message> getMessageClass(int key) {
		return typeMessage.get(key);
	}
	
	public static int getMessageType(Class<? extends Message> type) {
		return messageType.get(type);
	}
}

