/*
 * Decompiled with CFR 0.152.
 */
package com.hexnova.knight.notify.client;

import com.hexnova.knight.data.PseudoPlayerCredentials;
import com.hexnova.knight.notify.client.NotifyService;
import com.samskivert.Log;
import com.samskivert.util.BasicRunQueue;
import com.samskivert.util.RunQueue;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.EventListener;
import com.threerings.presents.dobj.MessageEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.net.Credentials;
import com.threerings.util.Name;

public class NotifyClient
extends BasicRunQueue
implements SessionObserver,
EventListener,
NotifyService,
Subscriber<ClientObject> {
    protected Client _client;

    public void setClient(Client client) {
        this._client = client;
    }

    public void clientWillLogon(Client client) {
        client.addServiceGroup("test");
    }

    public void clientDidLogon(Client client) {
        Log.log.info((Object)("Client did logon [client=" + client + "]."), new Object[0]);
        NotifyService service = (NotifyService)client.requireService(NotifyService.class);
    }

    public void clientObjectDidChange(Client client) {
        Log.log.info((Object)("Client object did change [client=" + client + "]."), new Object[0]);
    }

    public void objectAvailable(ClientObject object) {
        object.addListener((ChangeListener)this);
        Log.log.info((Object)("Object available: " + object), new Object[0]);
    }

    public void clientDidLogoff(Client client) {
        Log.log.info((Object)("Client did logoff [client=" + client + "]."), new Object[0]);
    }

    public void requestFailed(int oid, ObjectAccessException cause) {
        Log.log.info((Object)("Object unavailable [oid=" + oid + ", reason=" + cause + "]."), new Object[0]);
        this._client.logoff(true);
    }

    public void eventReceived(DEvent event) {
        Log.log.info((Object)("Got event [event=" + event + "]."), new Object[0]);
        if (event instanceof MessageEvent && ((MessageEvent)event).getName().equals("shutdown")) {
            this._client.logoff(true);
        }
    }

    public void requestFailed(String reason) {
        Log.log.info((Object)("Urk! Request failed [reason=" + reason + "]."), new Object[0]);
    }

    protected void willStart() {
        super.willStart();
        PseudoPlayerCredentials creds = new PseudoPlayerCredentials(new Name("payment:test"), "bb726e583f63cc51e59950", false);
        BasicRunQueue rqueue = new BasicRunQueue();
        Client client = new Client((Credentials)creds, (RunQueue)rqueue);
        this.setClient(client);
        client.addClientObserver((SessionObserver)this);
        client.setServer("192.168.3.201", Client.DEFAULT_SERVER_PORTS);
        client.logon();
        rqueue.run();
    }

    protected void iterate() {
        while (!this._client.isLoggedOn()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this._client.isLoggedOn()) continue;
            this._client.logon();
        }
        Runnable r = (Runnable)this._queue.get();
        try {
            r.run();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Runnable posted to RunQueue barfed.", new Object[]{t});
            this._queue.prepend((Object)r);
        }
    }

    public static void main(String[] args) {
        final NotifyClient tclient = new NotifyClient();
        tclient.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (tclient._client == null || !tclient._client.isLoggedOn()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        tclient.paymentNotify("struct@hexnova.com", 1000);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!tclient._client.isLoggedOn()) {
                    tclient.paymentNotify("struct@hexnova.com", 1000);
                }
            }
        };
        thread.start();
        try {
            tclient.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void paymentNotify(String passport, int bd) {
        NotifyService service = (NotifyService)this._client.requireService(NotifyService.class);
        service.paymentNotify(passport, bd);
    }
}

