/*
 * Decompiled with CFR 0.152.
 */
package com.hexnova.knight.data;

import com.samskivert.servlet.user.UserUtil;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.IdentUtil;
import com.threerings.util.Name;

public class KnightCredentials
extends UsernamePasswordCreds {
    public static final String STEAM_PREFIX = "steam:";
    public String ident;
    public String sessionId;
    public int siteId;
    public String invite;
    public String region;

    public KnightCredentials(long steamId) {
        this(new Name(STEAM_PREFIX + steamId), null);
    }

    public KnightCredentials(String sessionId, String username) {
        this(new Name(username), null);
        this.sessionId = sessionId;
    }

    public KnightCredentials(Name username, String password) {
        this(username, password, false);
    }

    public KnightCredentials(Name username, String password, boolean encrypted) {
        super(username, encrypted ? password : (password == null ? "" : UserUtil.encryptPassword((String)password)));
        this.ident = IdentUtil.getMachineIdentifier();
        if (this.ident != null && !this.ident.matches("S[A-Za-z0-9/+]{32}")) {
            this.ident = "C" + this.ident;
        }
        this.region = "";
        this.siteId = Integer.getInteger("siteId", 0);
        this.invite = System.getProperty("invite");
    }

    public KnightCredentials() {
    }

    public boolean hasSteamId() {
        return this._username.toString().startsWith(STEAM_PREFIX);
    }

    public long getSteamId() {
        String ustr = this._username.toString();
        return ustr.startsWith(STEAM_PREFIX) ? Long.parseLong(ustr.substring(STEAM_PREFIX.length())) : 0L;
    }

    public String getMachineIdent() {
        return this.ident;
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", ident=").append(this.ident);
    }
}

