/*
 * Decompiled with CFR 0.152.
 */
package com.hexnova.common.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger log = LoggerFactory.getLogger(HttpUtil.class);
    static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build();
    static CloseableHttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpInvoke(Map<String, String> paramters, String url, boolean post, Type t) throws IOException {
        Object request = null;
        request = post ? new HttpPost(url) : new HttpGet(url);
        request.setConfig(requestConfig);
        if (post) {
            ArrayList pairs = new ArrayList();
            if (paramters != null) {
                for (Map.Entry<String, String> entry : paramters.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                    pairs.add(pair);
                }
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity((List)pairs, "UTF-8"));
        } else if (paramters != null) {
            for (Map.Entry entry : paramters.entrySet()) {
                request.getParams().setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)request);){
            HttpEntity entity = closeableHttpResponse.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)os);
            }
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                log.error("url=" + url + ", http status=" + closeableHttpResponse.getStatusLine().getStatusCode());
            }
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            Object object = gson.fromJson(new String(os.toByteArray(), "UTF8"), t);
            return (T)object;
        }
    }

    public static <T> T httpPostInvoke(String body, ContentType type, String url, Type t) throws IOException {
        return HttpUtil.httpPostInvoke((HttpEntity)new StringEntity(body, type), url, t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T httpPostInvoke(HttpEntity body, String url, Type t, Map<String, String> headers) throws IOException {
        HttpPost request = new HttpPost(url);
        request.setConfig(requestConfig);
        if (headers != null) {
            for (String key : headers.keySet()) {
                request.addHeader(key, headers.get(key));
            }
        }
        request.setEntity(body);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                entity.writeTo((OutputStream)os);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                log.error("url=" + url + ", http status=" + response.getStatusLine().getStatusCode());
            }
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            Object object = gson.fromJson(new String(os.toByteArray(), "UTF8"), t);
            return (T)object;
        }
    }

    static {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(5000).setSoKeepAlive(true).setTcpNoDelay(true).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(200);
        connManager.setDefaultMaxPerRoute(50);
        connManager.setDefaultSocketConfig(socketConfig);
        ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                return 300000L;
            }
        };
        DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler();
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setRetryHandler((HttpRequestRetryHandler)retryHandler).build();
    }
}

