package com.hexnova.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ByteUtil {
	private static byte[] NULL_LENGTH = new byte[4]; 
	public static void writeLengthedString(OutputStream os,String s) throws IOException {
		if(s == null) {
			os.write(NULL_LENGTH);
		}else {
			byte[] bts = BitConverter.getBytes(s);
			os.write(BitConverter.getBytes(bts.length));
			os.write(bts);
		}
	}
	
	public static void writeLengthedBytes(OutputStream os,byte[] bts, int length) throws IOException {
		if(bts == null || length <= 0) {
			os.write(NULL_LENGTH);
		}else {
			if(bts.length < length ) {
				throw new IOException("parameter length is big than bts size");
			}
			os.write(BitConverter.getBytes(length));
			os.write(bts,0,length);
		}
	}
	
	
	public static void writeObject(OutputStream os,Serializable o)  throws IOException {
		if(o != null) {
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			ObjectOutputStream oos = new ObjectOutputStream(bos);
			oos.writeObject(o);
			oos.flush();
			oos.close();
			
			byte[] bts = bos.toByteArray();
			
			ByteUtil.writeLengthedBytes(os, bts,bts.length);
		}else {
			os.write(NULL_LENGTH);
		}
	}
	
	public static <T> T readObject(InputStream is) throws IOException, ClassNotFoundException {
		byte[] bts = readLengthedBytes(is);
		if(bts != null && bts.length > 0) {
			ByteArrayInputStream bis = new ByteArrayInputStream(bts);
			ObjectInputStream ois = new ObjectInputStream(bis);
			return (T)ois.readObject();
		}
		
		return null;
	}
	
	public static String readLengthedString(InputStream is) throws IOException {
		byte[] length = new byte[4];
		is.read(length);
		
		int len = BitConverter.toInt(length);
		if(len > 0) {
			byte[] bts = new byte[len];
			is.read(bts);
			return BitConverter.toString(bts);
		}else {
			return null;
		}
	}
	
	public static byte[] readLengthedBytes(InputStream is) throws IOException {
		byte[] length = new byte[4];
		is.read(length);
		
		int len = BitConverter.toInt(length);
		if(len > 0) {
			byte[] bts = new byte[len];
			is.read(bts);
			return bts;
		}else {
			return null;
		}
	}
	
}
