package com.hexnova.common.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

import com.hexnova.common.tencent.data.TencentUserToken;
import com.hexnova.common.util.ByteUtil;

public class UserGameModel implements Serializable{
	private static final long serialVersionUID = 1L;

	private UserToken token;
	private Channel channel;
	private RegionServer regionServer;

	public void setToken(UserToken token) {
		this.token = token;
	}

	public UserToken getToken() {
		return token;
	}

	public Channel getChannel() {
		return channel;
	}
	public void setChannel(Channel channel) {
		this.channel = channel;
	}
	
	public RegionServer getRegionServer() {
		return regionServer;
	}

	public void setRegionServer(RegionServer regionServer) {
		this.regionServer = regionServer;
	}

	public  static void main(String[] args) throws Exception {
		UserGameModel model = new UserGameModel();
		model.setToken(new TencentUserToken());
		model.setRegionServer(new RegionServer());
		
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		
		ByteUtil.writeObject(os, model);
		os.close();
		ByteArrayInputStream ios = new ByteArrayInputStream(os.toByteArray());
		
		UserGameModel model1 = ByteUtil.readObject(ios);
		System.out.println(model1);
	}
}
