package com.hexnova.common;

import java.util.Observable;

import com.hexnova.common.data.Channel;
import com.hexnova.common.data.RegionServer;
import com.hexnova.common.data.UserToken;

/**
 * 该类用于游戏客户端
 * @author Administrator
 *
 */
public class AppContext extends Observable{
	private static AppContext instance = new AppContext() ;

	public static AppContext getInstance() {
		return instance;
	}
	
	private UserToken token;
	private Channel channel;
	
	private RegionServer regionServer;
	
	public void setToken(UserToken token) {
		this.token = token;
		this.setChanged();
		this.notifyObservers(token);
	}
	
	public Channel getChannel() {
		return channel;
	}


	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public UserToken getToken() {
		return token;
	}

	public RegionServer getRegionServer() {
		return regionServer;
	}


	public void setRegionServer(RegionServer regionServer) {
		this.regionServer = regionServer;
	}
}