/*
 * Decompiled with CFR 0.152.
 */
package com.hexnova.common.util;

import java.io.ByteArrayOutputStream;
import java.util.Random;

public class Crypter {
    private byte[] plain;
    private byte[] prePlain;
    private byte[] out;
    private int crypt;
    private int preCrypt;
    private int pos;
    private int padding;
    private byte[] key;
    private boolean header = true;
    private int contextStart;
    private static Random random = new Random();
    private ByteArrayOutputStream baos = new ByteArrayOutputStream(8);

    private static long getUnsignedInt(byte[] in, int offset, int len) {
        long ret = 0L;
        int end = 0;
        end = len > 8 ? offset + 8 : offset + len;
        for (int i = offset; i < end; ++i) {
            ret <<= 8;
            ret |= (long)(in[i] & 0xFF);
        }
        return ret & 0xFFFFFFFFL | ret >>> 32;
    }

    public byte[] decrypt(byte[] in, int offset, int len, byte[] k) {
        int i;
        if (k == null) {
            return null;
        }
        this.preCrypt = 0;
        this.crypt = 0;
        this.key = k;
        byte[] m = new byte[offset + 8];
        if (len % 8 != 0 || len < 16) {
            return null;
        }
        this.prePlain = this.decipher(in, offset);
        this.pos = this.prePlain[0] & 7;
        int count = len - this.pos - 10;
        if (count < 0) {
            return null;
        }
        for (i = offset; i < m.length; ++i) {
            m[i] = 0;
        }
        this.out = new byte[count];
        this.preCrypt = 0;
        this.crypt = 8;
        this.contextStart = 8;
        ++this.pos;
        this.padding = 1;
        while (this.padding <= 2) {
            if (this.pos < 8) {
                ++this.pos;
                ++this.padding;
            }
            if (this.pos != 8) continue;
            m = in;
            if (this.decrypt8Bytes(in, offset, len)) continue;
            return null;
        }
        i = 0;
        while (count != 0) {
            if (this.pos < 8) {
                this.out[i] = (byte)(m[offset + this.preCrypt + this.pos] ^ this.prePlain[this.pos]);
                ++i;
                --count;
                ++this.pos;
            }
            if (this.pos != 8) continue;
            m = in;
            this.preCrypt = this.crypt - 8;
            if (this.decrypt8Bytes(in, offset, len)) continue;
            return null;
        }
        this.padding = 1;
        while (this.padding < 8) {
            if (this.pos < 8) {
                if ((m[offset + this.preCrypt + this.pos] ^ this.prePlain[this.pos]) != 0) {
                    return null;
                }
                ++this.pos;
            }
            if (this.pos == 8) {
                m = in;
                this.preCrypt = this.crypt;
                if (!this.decrypt8Bytes(in, offset, len)) {
                    return null;
                }
            }
            ++this.padding;
        }
        return this.out;
    }

    public byte[] decrypt(byte[] in, byte[] k) {
        return this.decrypt(in, 0, in.length, k);
    }

    public byte[] encrypt(byte[] in, int offset, int len, byte[] k) {
        int i;
        if (k == null) {
            return in;
        }
        this.plain = new byte[8];
        this.prePlain = new byte[8];
        this.pos = 1;
        this.padding = 0;
        this.preCrypt = 0;
        this.crypt = 0;
        this.key = k;
        this.header = true;
        this.pos = (len + 10) % 8;
        if (this.pos != 0) {
            this.pos = 8 - this.pos;
        }
        this.out = new byte[len + this.pos + 10];
        this.plain[0] = (byte)(this.rand() & 0xF8 | this.pos);
        for (i = 1; i <= this.pos; ++i) {
            this.plain[i] = (byte)(this.rand() & 0xFF);
        }
        ++this.pos;
        for (i = 0; i < 8; ++i) {
            this.prePlain[i] = 0;
        }
        this.padding = 1;
        while (this.padding <= 2) {
            if (this.pos < 8) {
                this.plain[this.pos++] = (byte)(this.rand() & 0xFF);
                ++this.padding;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        i = offset;
        while (len > 0) {
            if (this.pos < 8) {
                this.plain[this.pos++] = in[i++];
                --len;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        this.padding = 1;
        while (this.padding <= 7) {
            if (this.pos < 8) {
                this.plain[this.pos++] = 0;
                ++this.padding;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        return this.out;
    }

    public byte[] encrypt(byte[] in, byte[] k) {
        return this.encrypt(in, 0, in.length, k);
    }

    private byte[] encipher(byte[] in) {
        int loop = 16;
        long y = Crypter.getUnsignedInt(in, 0, 4);
        long z = Crypter.getUnsignedInt(in, 4, 4);
        long a = Crypter.getUnsignedInt(this.key, 0, 4);
        long b = Crypter.getUnsignedInt(this.key, 4, 4);
        long c = Crypter.getUnsignedInt(this.key, 8, 4);
        long d = Crypter.getUnsignedInt(this.key, 12, 4);
        long sum = 0L;
        long delta = -1640531527L;
        delta &= 0xFFFFFFFFL;
        while (loop-- > 0) {
            sum += delta;
            y += (z << 4) + a ^ z + (sum &= 0xFFFFFFFFL) ^ (z >>> 5) + b;
            z += ((y &= 0xFFFFFFFFL) << 4) + c ^ y + sum ^ (y >>> 5) + d;
            z &= 0xFFFFFFFFL;
        }
        this.baos.reset();
        this.writeInt((int)y);
        this.writeInt((int)z);
        return this.baos.toByteArray();
    }

    private byte[] decipher(byte[] in, int offset) {
        int loop = 16;
        long y = Crypter.getUnsignedInt(in, offset, 4);
        long z = Crypter.getUnsignedInt(in, offset + 4, 4);
        long a = Crypter.getUnsignedInt(this.key, 0, 4);
        long b = Crypter.getUnsignedInt(this.key, 4, 4);
        long c = Crypter.getUnsignedInt(this.key, 8, 4);
        long d = Crypter.getUnsignedInt(this.key, 12, 4);
        long sum = -478700656L;
        sum &= 0xFFFFFFFFL;
        long delta = -1640531527L;
        delta &= 0xFFFFFFFFL;
        while (loop-- > 0) {
            z -= (y << 4) + c ^ y + sum ^ (y >>> 5) + d;
            y -= ((z &= 0xFFFFFFFFL) << 4) + a ^ z + sum ^ (z >>> 5) + b;
            y &= 0xFFFFFFFFL;
            sum -= delta;
            sum &= 0xFFFFFFFFL;
        }
        this.baos.reset();
        this.writeInt((int)y);
        this.writeInt((int)z);
        return this.baos.toByteArray();
    }

    private void writeInt(int t) {
        this.baos.write(t >>> 24);
        this.baos.write(t >>> 16);
        this.baos.write(t >>> 8);
        this.baos.write(t);
    }

    private byte[] decipher(byte[] in) {
        return this.decipher(in, 0);
    }

    private void encrypt8Bytes() {
        this.pos = 0;
        while (this.pos < 8) {
            if (this.header) {
                int n = this.pos;
                this.plain[n] = (byte)(this.plain[n] ^ this.prePlain[this.pos]);
            } else {
                int n = this.pos;
                this.plain[n] = (byte)(this.plain[n] ^ this.out[this.preCrypt + this.pos]);
            }
            ++this.pos;
        }
        byte[] crypted = this.encipher(this.plain);
        System.arraycopy(crypted, 0, this.out, this.crypt, 8);
        this.pos = 0;
        while (this.pos < 8) {
            int n = this.crypt + this.pos;
            this.out[n] = (byte)(this.out[n] ^ this.prePlain[this.pos]);
            ++this.pos;
        }
        System.arraycopy(this.plain, 0, this.prePlain, 0, 8);
        this.preCrypt = this.crypt;
        this.crypt += 8;
        this.pos = 0;
        this.header = false;
    }

    private boolean decrypt8Bytes(byte[] in, int offset, int len) {
        this.pos = 0;
        while (this.pos < 8) {
            if (this.contextStart + this.pos >= len) {
                return true;
            }
            int n = this.pos;
            this.prePlain[n] = (byte)(this.prePlain[n] ^ in[offset + this.crypt + this.pos]);
            ++this.pos;
        }
        this.prePlain = this.decipher(this.prePlain);
        if (this.prePlain == null) {
            return false;
        }
        this.contextStart += 8;
        this.crypt += 8;
        this.pos = 0;
        return true;
    }

    public static byte[] Decrypt(byte[] input, byte[] key) {
        return Crypter.Decrypt(input, 0, input.length, key);
    }

    public static byte[] Decrypt(byte[] input, int offset, int len, byte[] key) {
        Crypter crypter = new Crypter();
        crypter.header = true;
        return crypter.decrypt(input, offset, len, key);
    }

    public static byte[] Encrypt(byte[] input, byte[] key) {
        Crypter crypter = new Crypter();
        crypter.header = true;
        return crypter.encrypt(input, key);
    }

    private int rand() {
        return random.nextInt();
    }

    public static byte[] stringToAscii(String value) {
        char[] chars = value.toCharArray();
        byte[] result = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = (byte)chars[i];
        }
        return result;
    }

    public static String bytesToString(byte[] bts) {
        char[] chars = new char[bts.length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)bts[i];
        }
        return new String(chars);
    }

    public static String bytesTohex(byte[] bytes) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String tmp;
            byte b = bytes[i];
            boolean flag = false;
            if (b < 0) {
                flag = true;
            }
            int absB = Math.abs(b);
            if (flag) {
                absB |= 0x80;
            }
            if ((tmp = Integer.toHexString(absB & 0xFF)).length() == 1) {
                hex.append("0");
            }
            hex.append(tmp.toLowerCase());
        }
        return hex.toString();
    }

    public static void main(String[] args) {
        byte[] bytes = Crypter.stringToAscii("HELLO QQGAME");
        System.out.println(Crypter.bytesTohex(bytes));
        Crypter crypter = new Crypter();
        byte[] encrypt_data = crypter.encrypt(bytes, Crypter.stringToAscii("QQGAMEPIPECONNECTION"));
        Crypter crypter1 = new Crypter();
        String s = Crypter.bytesTohex(encrypt_data);
        System.out.println(s);
        byte[] result = crypter1.decrypt(encrypt_data, Crypter.stringToAscii("QQGAMEPIPECONNECTION"));
        System.out.println(Crypter.bytesTohex(result));
    }
}

