package com.hexnova.common.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import com.hexnova.common.util.ByteUtil;


public class QQGameToken extends AbstractToken{
	public String openid;
	public String openkey;
	public String pipe;
	
	public void write(OutputStream os) throws IOException {
		ByteUtil.writeLengthedString(os,openid);
		ByteUtil.writeLengthedString(os,openkey);
		ByteUtil.writeLengthedString(os,pipe);
	}
	
	public void read(InputStream is) throws IOException {
		openid = ByteUtil.readLengthedString(is);
		openkey = ByteUtil.readLengthedString(is);
		pipe = ByteUtil.readLengthedString(is);
	}
}
