package com.hexnova.common;

import java.util.Observable;

import com.hexnova.common.data.Channel;
import com.hexnova.common.data.RegionServer;

public class AppContext extends Observable{
	private static AppContext instance = new AppContext() ;

	public static AppContext getInstance() {
		return instance;
	}
	
	private Object token;
	private Channel channel;
	
	private RegionServer regionServer;
	
	public void setToken(Object token) {
		this.token = token;
		this.setChanged();
		this.notifyObservers(token);
	}
	
	public Channel getChannel() {
		return channel;
	}


	public void setChannel(Channel channel) {
		this.channel = channel;
	}


	@SuppressWarnings("unchecked")
	public <T> T getToken() {
		return (T)token;
	}

	public RegionServer getRegionServer() {
		return regionServer;
	}


	public void setRegionServer(RegionServer regionServer) {
		this.regionServer = regionServer;
	}
}