/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server.persist;

import com.google.common.base.Function;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.GeneratedValue;
import com.samskivert.depot.annotation.GenerationType;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import com.threerings.coin.server.CoinExOffer;
import java.sql.Timestamp;

@Entity(name="COIN_EXCHANGE")
public class CoinExOfferRecord
extends PersistentRecord {
    public static final Class<CoinExOfferRecord> _R = CoinExOfferRecord.class;
    public static final ColumnExp OFFER_ID = CoinExOfferRecord.colexp(_R, (String)"offerId");
    public static final ColumnExp SERVER_ID = CoinExOfferRecord.colexp(_R, (String)"serverId");
    public static final ColumnExp GAME_NAME = CoinExOfferRecord.colexp(_R, (String)"gameName");
    public static final ColumnExp ACCOUNT_NAME = CoinExOfferRecord.colexp(_R, (String)"accountName");
    public static final ColumnExp BUY = CoinExOfferRecord.colexp(_R, (String)"buy");
    public static final ColumnExp PRICE = CoinExOfferRecord.colexp(_R, (String)"price");
    public static final ColumnExp VOLUME = CoinExOfferRecord.colexp(_R, (String)"volume");
    public static final ColumnExp ENTERED = CoinExOfferRecord.colexp(_R, (String)"entered");
    public static final int SCHEMA_VERSION = 1;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="OFFER_ID")
    public int offerId;
    @Column(name="SERVER_ID", length=255)
    public String serverId;
    @Column(name="GAME_NAME", length=255)
    public String gameName;
    @Column(name="ACCOUNT_NAME", length=255)
    public String accountName;
    @Column(name="BUY")
    public boolean buy;
    @Column(name="PRICE")
    public short price;
    @Column(name="VOLUME")
    public short volume;
    @Column(name="ENTERED")
    public Timestamp entered;
    public static Function<CoinExOfferRecord, CoinExOffer> TO_OFFER = new Function<CoinExOfferRecord, CoinExOffer>(){

        public CoinExOffer apply(CoinExOfferRecord rec) {
            CoinExOffer offer = new CoinExOffer();
            offer.offerId = rec.offerId;
            offer.serverId = rec.serverId;
            offer.gameName = rec.gameName;
            offer.accountName = rec.accountName;
            offer.buy = rec.buy;
            offer.price = rec.price;
            offer.volume = rec.volume;
            offer.entered = rec.entered;
            return offer;
        }
    };

    static {
        CoinExOfferRecord.registerKeyFields((ColumnExp[])new ColumnExp[]{OFFER_ID});
    }

    public static Key<CoinExOfferRecord> getKey(int offerId) {
        return CoinExOfferRecord.newKey(_R, (Comparable[])new Comparable[]{Integer.valueOf(offerId)});
    }

    public CoinExOfferRecord() {
    }

    public CoinExOfferRecord(CoinExOffer offer) {
        this.offerId = offer.offerId;
        this.serverId = offer.serverId;
        this.gameName = offer.gameName;
        this.accountName = offer.accountName;
        this.buy = offer.buy;
        this.price = offer.price;
        this.volume = offer.volume;
        this.entered = offer.entered;
    }
}

