/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.coin.server;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.util.AuditLogger;
import com.samskivert.util.ChainedResultListener;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.IntResultListener;
import com.samskivert.util.Invoker;
import com.samskivert.util.ResultListener;
import com.threerings.coin.Log;
import com.threerings.coin.data.CoinExOfferInfo;
import com.threerings.coin.server.CoinExOffer;
import com.threerings.coin.server.CoinManager;
import com.threerings.coin.server.persist.CoinExchangeRepository;
import com.threerings.coin.util.TransferUtil;
import com.threerings.presents.data.InvocationCodes;
import com.threerings.presents.server.InvocationException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoinExchangeManager
implements InvocationCodes {
    public static final long PERIODIC_DELETE_START_INTERVAL = 300000L;
    public static final long PERIODIC_DELETE_REPEAT_INTERVAL = 3600000L;
    protected CoinExchangeRepository _coinExRepo;
    protected boolean _active = false;
    protected CoinManager _coinmgr;
    protected Invoker _invoker;
    protected AuditLogger _audit;
    protected int _offersShown;
    protected short _lastPrice = (short)-1;
    protected ComparableArrayList<CoinExOffer> _bids = new ComparableArrayList();
    protected ComparableArrayList<CoinExOffer> _asks = new ComparableArrayList();
    protected static final long MAX_LIFETIME = 864000000L;

    public CoinExchangeManager(PersistenceContext ctx, String serverId) {
        this._coinExRepo = new CoinExchangeRepository(ctx, serverId);
    }

    public CoinExchangeManager(ConnectionProvider conprov, String serverId) {
        this(new PersistenceContext("coinexchdb", conprov, null), serverId);
    }

    public void init(CoinManager coinmgr, Invoker invoker, AuditLogger audit, int offersShown) {
        this._invoker = invoker;
        this._audit = audit;
        this._coinmgr = coinmgr;
        this._offersShown = offersShown;
        int totalCoins = 0;
        for (CoinExOffer offer : this._coinExRepo.loadAll()) {
            this.mapOffer(offer, false);
            if (offer.buy) continue;
            totalCoins += offer.volume;
        }
        int totalOut = this._coinmgr.getCoinRepository().getCoinCount("@@SERVER@@");
        if (totalOut < totalCoins) {
            Log.log.warning((Object)"Christofilus! The coin exchange is writing checks that it can't cash! Disabling.", new Object[]{"totalOut", totalOut, "totalCoins", totalCoins});
            this._active = false;
            return;
        }
        this._active = true;
        this._lastPrice = this._coinExRepo.getLastPrice();
    }

    public void periodicDeleteOffers() {
        final long oldest = System.currentTimeMillis() - 864000000L;
        this.serverDeleteOffers(true, new Predicate<CoinExOffer>(){

            public boolean apply(CoinExOffer offer) {
                return offer.entered.getTime() < oldest;
            }
        });
    }

    public void userWasDeleted(final String gameName) {
        if (!this._active) {
            Log.log.warning((Object)"Could not cope with deleted user, we're inactive.", new Object[]{"user", gameName});
            return;
        }
        this.serverDeleteOffers(false, new Predicate<CoinExOffer>(){

            public boolean apply(CoinExOffer offer) {
                return offer.gameName.equals(gameName);
            }
        });
    }

    public void postOffer(final Object user, final CoinExOffer offer, final boolean fillOrKill, ResultListener<CoinExOfferInfo> listener) {
        ChainedResultListener<Void, CoinExOfferInfo> rl = new ChainedResultListener<Void, CoinExOfferInfo>(listener){

            public void requestCompleted(Void result) {
                CoinExchangeManager.this.updateUserCoins(offer.gameName, offer.accountName);
                CoinExchangeManager.this.postOffer2(user, offer, fillOrKill, (ResultListener<CoinExOfferInfo>)this._target);
            }
        };
        if (offer.buy) {
            this.reserveCurrency(user, offer.price * offer.volume, (ResultListener<Void>)rl);
        } else {
            this._coinmgr.reserveCoins(offer.accountName, offer.volume, new IntResultListener((ResultListener)rl){
                private final /* synthetic */ ResultListener val$rl;
                {
                    this.val$rl = resultListener;
                }

                public void requestCompleted(int result) {
                    CoinExchangeManager.this._coinmgr.transferReservation(result, "@@SERVER@@", 3, "m.coinex_offer_posted", "m.coinex_offer_received", (ResultListener<Void>)this.val$rl);
                }

                public void requestFailed(Exception cause) {
                    this.val$rl.requestFailed(cause);
                }
            });
        }
    }

    public boolean cancelOffer(final String gameName, final int offerId) {
        int found = this.serverDeleteOffers(true, new Predicate<CoinExOffer>(){

            public boolean apply(CoinExOffer offer) {
                return offer.offerId == offerId && offer.gameName.equals(gameName);
            }
        });
        return found > 0;
    }

    protected void postOffer2(Object user, CoinExOffer newOffer, boolean fillOrKill, ResultListener<CoinExOfferInfo> listener) {
        ComparableArrayList<CoinExOffer> list = newOffer.buy ? this._asks : this._bids;
        int totalVolume = 0;
        int ii = 0;
        int nn = list.size();
        while (ii < nn) {
            CoinExOffer candidate = (CoinExOffer)list.get(ii);
            if ((!newOffer.buy || candidate.price > newOffer.price) && (newOffer.buy || candidate.price < newOffer.price) || (totalVolume += candidate.volume) >= newOffer.volume) break;
            ++ii;
        }
        if (fillOrKill && totalVolume < newOffer.volume) {
            if (newOffer.buy) {
                this.distributeCurrency(newOffer, newOffer.price * newOffer.volume, "m.coins_cancelled_poe");
            } else {
                this.distributeCoins(newOffer, newOffer.volume, true);
            }
            listener.requestFailed((Exception)new InvocationException("m.could_not_fill"));
            return;
        }
        this.postOffer3((List<CoinExOffer>)list, newOffer, fillOrKill, listener);
    }

    protected void postOffer3(List<CoinExOffer> candidates, CoinExOffer newOffer, boolean fillOrKill, ResultListener<CoinExOfferInfo> listener) {
        ArrayList destroyed = Lists.newArrayList();
        CoinExOffer modified = null;
        int newOfferValue = 0;
        int newOfferRemainder = 0;
        ListIterator<CoinExOffer> itr = candidates.listIterator();
        while (itr.hasNext()) {
            CoinExOffer seller;
            CoinExOffer buyer;
            CoinExOffer oldOffer = (CoinExOffer)itr.next();
            if (newOffer.buy) {
                buyer = newOffer;
                seller = oldOffer;
            } else {
                buyer = oldOffer;
                seller = newOffer;
            }
            if (buyer.price < seller.price) break;
            int vol = Math.min(buyer.volume, seller.volume);
            int sellerFee = TransferUtil.calculateFee(seller.price, vol, this.getFee());
            int sellerReturn = seller.price * vol - sellerFee;
            int remainder = (buyer.price - seller.price) * vol;
            this.tradeCompleted(seller.price, vol, seller.accountName, buyer.accountName, buyer.gameName);
            if (oldOffer == buyer) {
                this.distributeCoins(buyer, vol, false);
                if (remainder > 0) {
                    this.distributeCurrency(buyer, remainder, "m.coins_remainder_poe");
                }
                newOfferValue += sellerReturn;
            } else {
                if (sellerReturn > 0) {
                    this.distributeCurrency(seller, sellerReturn);
                }
                newOfferValue += vol;
                newOfferRemainder += remainder;
            }
            this._lastPrice = seller.price;
            CoinExOffer tmp248_247 = newOffer;
            tmp248_247.volume = (short)(tmp248_247.volume - vol);
            CoinExOffer tmp261_259 = oldOffer;
            tmp261_259.volume = (short)(tmp261_259.volume - vol);
            if (oldOffer.volume == 0) {
                this._audit.log("offer_closed offerId=" + oldOffer.offerId, new Object[0]);
                itr.remove();
                destroyed.add(oldOffer);
            } else {
                modified = oldOffer;
            }
            if (newOffer.volume == 0) break;
        }
        if (newOfferValue > 0) {
            if (newOffer.buy) {
                this.distributeCoins(newOffer, newOfferValue, false);
                if (newOfferRemainder > 0) {
                    this.distributeCurrency(newOffer, newOfferRemainder, "m.coins_remainder_poe");
                }
            } else {
                this.distributeCurrency(newOffer, newOfferValue);
            }
        }
        if (modified != null || !destroyed.isEmpty()) {
            this.updatePublishedInfo(!newOffer.buy, newOffer.buy, this._lastPrice);
            if (modified != null) {
                this.offerModified(modified);
            }
            if (!destroyed.isEmpty()) {
                this.offersDestroyed(destroyed);
            }
        }
        this.postOffer4(newOffer, modified, destroyed, listener);
    }

    protected void postOffer4(final CoinExOffer offer, final CoinExOffer modified, final List<CoinExOffer> destroyed, final ResultListener<CoinExOfferInfo> listener) {
        this._invoker.postUnit(new Invoker.Unit(){

            public boolean invoke() {
                if (modified != null) {
                    try {
                        CoinExchangeManager.this._coinExRepo.update(modified);
                    }
                    catch (DatabaseException de) {
                        Log.log.warning((Object)("Could not save modified offer " + modified + "."), new Object[]{de});
                    }
                }
                int ii = 0;
                while (ii < destroyed.size()) {
                    CoinExOffer offer2 = (CoinExOffer)destroyed.get(ii);
                    try {
                        CoinExchangeManager.this._coinExRepo.remove(offer2);
                    }
                    catch (DatabaseException de) {
                        Log.log.warning((Object)("Could not remove destroyed offer " + offer2 + "."), new Object[]{de});
                    }
                    ++ii;
                }
                if (offer.volume > 0) {
                    try {
                        CoinExchangeManager.this._coinExRepo.insert(offer);
                    }
                    catch (DatabaseException de) {
                        Log.log.warning((Object)("Could not add new offer: " + offer + "."), new Object[]{de});
                    }
                }
                if (modified != null || !destroyed.isEmpty()) {
                    try {
                        CoinExchangeManager.this._coinExRepo.setLastPrice(CoinExchangeManager.this._lastPrice);
                    }
                    catch (DatabaseException de) {
                        Log.log.warning((Object)"Could not save last price", new Object[]{de});
                    }
                }
                return true;
            }

            public void handleResult() {
                if (offer.volume == 0) {
                    listener.requestCompleted(null);
                } else {
                    CoinExchangeManager.this.mapOffer(offer, true);
                    CoinExchangeManager.this._audit.log("offer_posted " + offer, new Object[0]);
                    listener.requestCompleted((Object)CoinExchangeManager.this.createInfo(offer));
                }
            }
        });
    }

    protected int serverDeleteOffers(final boolean refundCurrency, Predicate<CoinExOffer> pred) {
        final ArrayList toRemove = Lists.newArrayList();
        boolean[] publish = new boolean[2];
        int ii = 0;
        while (ii < 2) {
            ComparableArrayList<CoinExOffer> offers = ii == 0 ? this._bids : this._asks;
            boolean first = true;
            boolean update = false;
            int jj = 0;
            int nn = offers.size();
            while (jj < nn) {
                CoinExOffer off = (CoinExOffer)offers.get(jj);
                if (pred.apply((Object)off)) {
                    if (first) {
                        first = false;
                        update = jj < this._offersShown || this.inTopOffers((List<CoinExOffer>)offers, off.price);
                    }
                    offers.remove(jj);
                    toRemove.add(off);
                    --nn;
                    --jj;
                }
                ++jj;
            }
            if (update) {
                publish[ii] = true;
            }
            ++ii;
        }
        if (publish[0] || publish[1]) {
            this.updatePublishedInfo(publish[0], publish[1], -1);
        }
        if (!toRemove.isEmpty()) {
            this.offersDestroyed(toRemove);
        }
        this._invoker.postUnit(new Invoker.Unit(){

            public boolean invoke() {
                int ii = 0;
                int nn = toRemove.size();
                while (ii < nn) {
                    try {
                        CoinExchangeManager.this._coinExRepo.remove((CoinExOffer)toRemove.get(ii));
                    }
                    catch (DatabaseException de) {
                        Log.log.warning((Object)("Crimminy! Unable to delete offer: " + (Object)((Object)de)), new Object[0]);
                    }
                    ++ii;
                }
                return true;
            }

            public void handleResult() {
                int ii = 0;
                int nn = toRemove.size();
                while (ii < nn) {
                    CoinExOffer offer = (CoinExOffer)toRemove.get(ii);
                    if (!offer.buy) {
                        CoinExchangeManager.this.distributeCoins(offer, offer.volume, true);
                    } else if (refundCurrency) {
                        CoinExchangeManager.this.distributeCurrency(offer, offer.price * offer.volume, "m.coins_cancelled_poe");
                    }
                    CoinExchangeManager.this._audit.log("offer_cancelled " + offer, new Object[0]);
                    ++ii;
                }
            }
        });
        return toRemove.size();
    }

    protected void mapOffer(CoinExOffer offer, boolean publish) {
        ComparableArrayList<CoinExOffer> list = offer.buy ? this._bids : this._asks;
        int index = list.insertSorted((Comparable)offer);
        if (publish && (index < this._offersShown || this.inTopOffers((List<CoinExOffer>)list, offer.price))) {
            this.updatePublishedInfo(offer.buy, !offer.buy, -1);
        }
        this.offerModified(offer);
    }

    protected boolean inTopOffers(List<CoinExOffer> list, short price) {
        short lastPrice = -1;
        int pricesSeen = 0;
        int ii = 0;
        int nn = list.size();
        while (ii < nn) {
            short oprice = list.get((int)ii).price;
            if (lastPrice != oprice) {
                if (oprice == price) {
                    return true;
                }
                if (++pricesSeen == this._offersShown) break;
                lastPrice = oprice;
            }
            ++ii;
        }
        return false;
    }

    protected CoinExOfferInfo createInfo(CoinExOffer offer) {
        CoinExOfferInfo info = new CoinExOfferInfo();
        info.offerId = offer.offerId;
        info.buy = offer.buy;
        info.price = offer.price;
        info.volume = offer.volume;
        return info;
    }

    protected void tradeCompleted(int price, int vol, String seller, String buyer, String buyerGame) {
        this._audit.log("trade_completed price=" + price + ", volume=" + vol + ", buyer=" + buyer + ", seller=" + seller, new Object[0]);
    }

    protected abstract void updatePublishedInfo(boolean var1, boolean var2, int var3);

    protected void offersDestroyed(List<CoinExOffer> destroyed) {
    }

    protected void offerModified(CoinExOffer modified) {
    }

    protected abstract void reserveCurrency(Object var1, int var2, ResultListener<Void> var3);

    protected abstract byte getFee();

    protected abstract void updateUserCoins(String var1, String var2);

    protected abstract void distributeCurrency(CoinExOffer var1, int var2, String var3);

    protected void distributeCurrency(CoinExOffer info, int currency) {
        this.distributeCurrency(info, currency, "m.coins_traded_poe");
    }

    protected void distributeCoins(final CoinExOffer info, final int coins, final boolean cancel) {
        ResultListener<Void> rl = new ResultListener<Void>(){

            public void requestCompleted(Void result) {
                CoinExchangeManager.this.updateUserCoins(info.gameName, info.accountName);
            }

            public void requestFailed(Exception cause) {
                Log.log.warning((Object)("Unable to distribute coins to trader [offer=" + info + ", coins=" + coins + "]."), new Object[]{cause});
            }
        };
        IntResultListener irl = new IntResultListener((ResultListener)rl, coins){
            private final /* synthetic */ ResultListener val$rl;
            private final /* synthetic */ int val$coins;
            {
                this.val$rl = resultListener;
                this.val$coins = n;
            }

            public void requestCompleted(int result) {
                String destDesc = cancel ? "m.coinex_offer_cancelled" : "m.coinex_offer_paid";
                CoinExchangeManager.this._coinmgr.transferReservation(result, info.accountName, 3, "m.coinex_offer_distrib", destDesc, (ResultListener<Void>)this.val$rl);
            }

            public void requestFailed(Exception cause) {
                Log.log.warning((Object)("Unable to distribute coins to trader [offer=" + info + ", coins=" + this.val$coins + "]."), new Object[]{cause});
            }
        };
        this._coinmgr.reserveCoins("@@SERVER@@", coins, irl);
    }
}

