/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.venus.manager.service;

import com.meidusa.venus.support.MonitorResource;
import com.meidusa.venus.util.VenusLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;

public class DefaultMonitorResource
implements MonitorResource {
    private static Logger logger = VenusLoggerFactory.getDefaultLogger();
    private static Logger exceptionLogger = VenusLoggerFactory.getExceptionLogger();
    private static boolean isRunning = false;
    private String version;
    private Map<String, Object> properties = new HashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        logger.info("start resource monitor.");
        Class<DefaultMonitorResource> clazz = DefaultMonitorResource.class;
        synchronized (DefaultMonitorResource.class) {
            if (!isRunning) {
                Timer timer = new Timer();
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        DefaultMonitorResource.this.oneHourTask();
                    }
                };
                timer.schedule(timerTask, 5000L, 3600000L);
                timer = new Timer();
                timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        DefaultMonitorResource.this.oneMinutesTask();
                    }
                };
                timer.schedule(timerTask, 5000L, 600000L);
                isRunning = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void oneHourTask() {
    }

    void oneMinutesTask() {
    }

    static void readVersion() {
        String file = DefaultMonitorResource.class.getResource("/version.txt").getFile();
        String version = DefaultMonitorResource.readFile(new File(file));
        if (logger.isInfoEnabled()) {
            logger.info(version);
        }
    }

    static String readFile(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(System.lineSeparator() + s);
            }
            br.close();
        }
        catch (Exception e) {
            exceptionLogger.error("read file failed.", (Throwable)e);
        }
        return result.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addProperty(String key, Object object) {
        this.properties.put(key, object);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, Object> getAllProperties() {
        return this.properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

