/*
 * Decompiled with CFR 0.152.
 */
package com.saic.ebiz.file.client.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MimeTypeUtils {
    public static Map<String, String> mimeTypeMap = new HashMap<String, String>();
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";

    public static String getMimeType(String suffix) {
        String mimeType = mimeTypeMap.get(suffix);
        if (StringUtils.isEmpty((String)mimeType)) {
            return DEFAULT_MIME_TYPE;
        }
        return mimeType;
    }

    static {
        mimeTypeMap.put("html", "text/html");
        mimeTypeMap.put("htm", "text/html");
        mimeTypeMap.put("shtml", "text/html");
        mimeTypeMap.put("css", "text/css");
        mimeTypeMap.put("xml", "text/xml");
        mimeTypeMap.put("gif", "image/gif");
        mimeTypeMap.put("jpg", "image/jpeg");
        mimeTypeMap.put("jpeg", "image/jpeg");
        mimeTypeMap.put("js", "application/x-javascript");
        mimeTypeMap.put("atom", "application/atom+xml");
        mimeTypeMap.put("rss", "application/rss+xml");
        mimeTypeMap.put("mml", "text/mathml");
        mimeTypeMap.put("txt", "text/plain");
        mimeTypeMap.put("jad", "text/vnd.sun.j2me.app-descriptor");
        mimeTypeMap.put("wml", "text/vnd.wap.wml");
        mimeTypeMap.put("htc", "text/x-component");
        mimeTypeMap.put("png", "image/png");
        mimeTypeMap.put("tif", "image/tiff");
        mimeTypeMap.put("tiff", "image/tiff");
        mimeTypeMap.put("wbmp", "image/vnd.wap.wbmp");
        mimeTypeMap.put("ico", "image/x-icon");
        mimeTypeMap.put("jng", "image/x-jng");
        mimeTypeMap.put("bmp", "image/x-ms-bmp");
        mimeTypeMap.put("svg", "image/svg+xml");
        mimeTypeMap.put("svgz", "image/svg+xml");
        mimeTypeMap.put("webp", "image/webp");
        mimeTypeMap.put("jar", "application/java-archive");
        mimeTypeMap.put("war", "application/java-archive");
        mimeTypeMap.put("ear", "application/java-archive");
        mimeTypeMap.put("hqx", "application/mac-binhex40");
        mimeTypeMap.put("doc", "application/msword");
        mimeTypeMap.put("pdf", "application/pdf");
        mimeTypeMap.put("ps", "application/postscript");
        mimeTypeMap.put("eps", "application/postscript");
        mimeTypeMap.put("ai", "application/postscript");
        mimeTypeMap.put("rtf", "application/rtf");
        mimeTypeMap.put("xls", "application/vnd.ms-excel");
        mimeTypeMap.put("ppt", "application/vnd.ms-powerpoint");
        mimeTypeMap.put("kml", "application/vnd.google-earth.kml+xml");
        mimeTypeMap.put("kmz", "application/vnd.google-earth.kmz");
        mimeTypeMap.put("7z", "application/x-7z-compressed");
        mimeTypeMap.put("cco", "application/x-cocoa");
        mimeTypeMap.put("jardiff", "application/x-java-archive-diff");
        mimeTypeMap.put("jnlp", "application/x-java-jnlp-file");
        mimeTypeMap.put("run", "application/x-makeself");
        mimeTypeMap.put("pl", "application/x-perl");
        mimeTypeMap.put("pm", "application/x-perl");
        mimeTypeMap.put("prc", "application/x-pilot");
        mimeTypeMap.put("pdb", "application/x-pilot");
        mimeTypeMap.put("rar", "application/x-rar-compressed");
        mimeTypeMap.put("rpm", "application/x-redhat-package-manager");
        mimeTypeMap.put("sea", "application/x-sea");
        mimeTypeMap.put("swf", "application/x-shockwave-flash");
        mimeTypeMap.put("sit", "application/x-stuffit");
        mimeTypeMap.put("tcl", "application/x-tcl");
        mimeTypeMap.put("tk", "application/x-tcl");
        mimeTypeMap.put("der", "application/x-x509-ca-cert");
        mimeTypeMap.put("pem", "application/x-x509-ca-cert");
        mimeTypeMap.put("crt", "application/x-x509-ca-cert");
        mimeTypeMap.put("xpi", "application/x-xpinstall");
        mimeTypeMap.put("xhtml", "application/xhtml+xml");
        mimeTypeMap.put("zip", "application/zip");
        mimeTypeMap.put("bin", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("exe", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("dll", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("deb", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("dmg", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("eot", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("iso", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("img", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("msi", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("msp", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("msm", DEFAULT_MIME_TYPE);
        mimeTypeMap.put("mid", "audio/midi");
        mimeTypeMap.put("midi", "audio/midi");
        mimeTypeMap.put("kar", "audio/midi");
        mimeTypeMap.put("mp3", "audio/mpeg");
        mimeTypeMap.put("ogg", "audio/ogg");
        mimeTypeMap.put("m4a", "audio/x-m4a");
        mimeTypeMap.put("ra", "audio/x-realaudio");
        mimeTypeMap.put("3gpp", "video/3gpp");
        mimeTypeMap.put("3gp", "video/3gpp");
        mimeTypeMap.put("mp4", "video/mp4");
        mimeTypeMap.put("mpeg", "video/mpeg");
        mimeTypeMap.put("mpg", "video/mpeg");
        mimeTypeMap.put("mov", "video/quicktime");
        mimeTypeMap.put("webm", "video/webm");
        mimeTypeMap.put("flv", "video/x-flv");
        mimeTypeMap.put("m4v", "video/x-m4v");
        mimeTypeMap.put("mng", "video/x-mng");
        mimeTypeMap.put("asx", "video/x-ms-asf");
        mimeTypeMap.put("asf", "video/x-ms-asf");
        mimeTypeMap.put("wmv", "video/x-ms-wmv");
        mimeTypeMap.put("avi", "video/x-msvideo");
    }
}

