/*
 * Decompiled with CFR 0.152.
 */
package com.saic.ebiz.file.client.service;

import com.saic.ebiz.file.client.exception.UploadException;
import com.saic.ebiz.file.client.service.FileUploadService;
import com.saic.ebiz.file.client.utils.MimeTypeUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileUploadService
implements FileUploadService {
    private static Logger logger = LoggerFactory.getLogger(DefaultFileUploadService.class);
    private String username;
    private String password;
    private String url;
    private CloseableHttpClient client = HttpClients.createDefault();

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String doUpload(File file) throws IOException, UploadException {
        if (StringUtils.isEmpty((String)this.url)) {
            throw new UploadException(404, "please type your upload ");
        }
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("upload file cannot be empty");
        }
        HttpPost httppost = new HttpPost(this.url);
        String[] names = file.getName().split("\\.");
        ContentType contentType = null;
        contentType = names.length > 1 ? ContentType.create((String)MimeTypeUtils.getMimeType(names[names.length - 1])) : ContentType.create((String)"application/octet-stream");
        HttpEntity reqEntity = MultipartEntityBuilder.create().addBinaryBody("file", file, contentType, file.getName()).build();
        httppost.setEntity(reqEntity);
        String ret = null;
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)httppost);){
            HttpEntity resEntity;
            if (response != null && response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
                resEntity = response.getEntity();
                if (resEntity != null) {
                    ret = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
                }
            } else {
                throw new IOException("upload no response");
            }
            EntityUtils.consume((HttpEntity)resEntity);
            if (StringUtils.isEmpty((String)ret)) {
                throw new IOException("response is empty");
            }
            JSONObject obj = new JSONObject(ret);
            int errorCode = obj.getInt("errorCode");
            if (errorCode != 200) {
                throw new UploadException(errorCode, "reponse not success");
            }
            String string = obj.getString("uuid");
            return string;
        }
    }
}

