/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.toolkit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.terracotta.toolkit.InvalidToolkitConfigException;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.ToolkitInstantiationException;
import org.terracotta.toolkit.api.ToolkitFactoryService;

public final class ToolkitFactory {
    private static final String TOOLKIT_URI_DELIM = ":";
    private static final String TOOLKIT_URI_PREFIX = "toolkit:";

    public static Toolkit createToolkit(String toolkitURI) throws ToolkitInstantiationException, InvalidToolkitConfigException, IllegalArgumentException {
        return ToolkitFactory.createToolkit(toolkitURI, null);
    }

    public static Toolkit createToolkit(String toolkitURI, Properties properties) throws ToolkitInstantiationException, InvalidToolkitConfigException, IllegalArgumentException {
        return ToolkitFactory.create(toolkitURI, properties);
    }

    private static Toolkit create(String toolkitURI, Properties properties) throws ToolkitInstantiationException {
        ToolkitTypeSubNameTuple typeSubName = ToolkitTypeSubNameTuple.parseToolkitURI(toolkitURI);
        ArrayList<ToolkitFactoryService> serviceList = new ArrayList<ToolkitFactoryService>();
        for (ToolkitFactoryService toolkitFactoryService : ToolkitFactoryServiceLookup.getToolkitFactoryServices()) {
            if (!toolkitFactoryService.canHandleToolkitType(typeSubName.type, typeSubName.subName)) continue;
            serviceList.add(toolkitFactoryService);
        }
        if (serviceList.size() == 0) {
            throw new ToolkitInstantiationException("No Toolkit implementation found in classpath for toolkitURI: " + toolkitURI);
        }
        if (serviceList.size() == 1) {
            return ((ToolkitFactoryService)serviceList.get(0)).createToolkit(typeSubName.type, typeSubName.subName, properties);
        }
        StringBuilder sb = new StringBuilder();
        for (ToolkitFactoryService service : serviceList) {
            sb.append(service.getClass().getName());
            sb.append(", ");
        }
        throw new ToolkitInstantiationException("Multiple Toolkit implementation found in classpath for toolkitURI: " + toolkitURI + " Services : " + sb.toString());
    }

    private static class ToolkitFactoryServiceLookup {
        private static final ServiceLoader<ToolkitFactoryService> TOOLKIT_FACTORY_SERVICE_LOADER = ServiceLoader.load(ToolkitFactoryService.class, ToolkitFactoryServiceLookup.class.getClassLoader());

        private ToolkitFactoryServiceLookup() {
        }

        private static Iterable<ToolkitFactoryService> getToolkitFactoryServices() {
            return new Iterable<ToolkitFactoryService>(){

                @Override
                public Iterator<ToolkitFactoryService> iterator() {
                    return TOOLKIT_FACTORY_SERVICE_LOADER.iterator();
                }
            };
        }
    }

    private static class ToolkitTypeSubNameTuple {
        private final String type;
        private final String subName;

        private ToolkitTypeSubNameTuple(String type, String subName) {
            this.type = type;
            this.subName = subName;
        }

        private static ToolkitTypeSubNameTuple parseToolkitURI(String toolkitURI) {
            if (toolkitURI == null || toolkitURI.trim().equals("")) {
                throw new IllegalArgumentException("toolkitURI cannot be null or blank");
            }
            if (!toolkitURI.startsWith(ToolkitFactory.TOOLKIT_URI_PREFIX)) {
                throw new IllegalArgumentException("toolkitURI should start with 'toolkit:', toolkitURI='" + toolkitURI + "'");
            }
            String[] tokens = toolkitURI.split(ToolkitFactory.TOOLKIT_URI_DELIM, 3);
            if (tokens.length != 3) {
                throw new IllegalArgumentException("toolkitURI should be in the form \"toolkit:type:subName\", toolkitURI='" + toolkitURI + "'");
            }
            return new ToolkitTypeSubNameTuple(tokens[1], tokens[2]);
        }
    }
}

