/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.functions;

import org.springmodules.validation.valang.ValangException;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.functions.FunctionCallback;
import org.springmodules.validation.valang.functions.FunctionTemplate;

public abstract class AbstractFunction
implements Function {
    private Function[] arguments = null;
    private FunctionTemplate template = null;

    public AbstractFunction(Function[] arguments, int line, int column) {
        this.setArguments(arguments);
        this.setTemplate(new FunctionTemplate(line, column));
    }

    public Function[] getArguments() {
        return this.arguments;
    }

    protected void definedMinNumberOfArguments(int minNumberOfArguments) {
        if (this.getArguments().length < minNumberOfArguments) {
            throw new ValangException("Function requires at least " + minNumberOfArguments + " argument(s)", this.getTemplate().getLine(), this.getTemplate().getColumn());
        }
    }

    protected void definedMaxNumberOfArguments(int maxNumberOfArguments) {
        if (this.getArguments().length > maxNumberOfArguments) {
            throw new ValangException("Function cannot have more than " + maxNumberOfArguments + " arguments(s)", this.getTemplate().getLine(), this.getTemplate().getColumn());
        }
    }

    protected void definedExactNumberOfArguments(int exactNumberOfArguments) {
        if (this.getArguments().length != exactNumberOfArguments) {
            throw new ValangException("Function must have exactly " + exactNumberOfArguments + " arguments", this.getTemplate().getLine(), this.getTemplate().getColumn());
        }
    }

    private void setArguments(Function[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Function parameters should not be null!");
        }
        this.arguments = arguments;
    }

    private void setTemplate(FunctionTemplate template) {
        this.template = template;
    }

    protected FunctionTemplate getTemplate() {
        return this.template;
    }

    public final Object getResult(Object target) {
        return this.getTemplate().execute(target, new FunctionCallback(){

            public Object execute(Object target) throws Exception {
                return AbstractFunction.this.doGetResult(target);
            }
        });
    }

    protected abstract Object doGetResult(Object var1) throws Exception;

    public boolean isAutowireByType() {
        return false;
    }

    public boolean isAutowireByName() {
        return false;
    }

    public void init() throws Exception {
    }
}

