/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping
implements MatchableHandlerMapping {
    private Object rootHandler;
    private boolean useTrailingSlashMatch = false;
    private boolean lazyInitHandlers = false;
    private final Map<String, Object> handlerMap = new LinkedHashMap<String, Object>();

    public void setRootHandler(Object rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Nullable
    public Object getRootHandler() {
        return this.rootHandler;
    }

    public void setUseTrailingSlashMatch(boolean useTrailingSlashMatch) {
        this.useTrailingSlashMatch = useTrailingSlashMatch;
    }

    public boolean useTrailingSlashMatch() {
        return this.useTrailingSlashMatch;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    @Override
    @Nullable
    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        Object handler = this.lookupHandler(lookupPath, request);
        if (handler == null) {
            Object rawHandler = null;
            if ("/".equals(lookupPath)) {
                rawHandler = this.getRootHandler();
            }
            if (rawHandler == null) {
                rawHandler = this.getDefaultHandler();
            }
            if (rawHandler != null) {
                if (rawHandler instanceof String) {
                    String handlerName = (String)rawHandler;
                    rawHandler = this.obtainApplicationContext().getBean(handlerName);
                }
                this.validateHandler(rawHandler, request);
                handler = this.buildPathExposingHandler(rawHandler, lookupPath, lookupPath, null);
            }
        }
        if (handler != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapping [" + lookupPath + "] to " + handler));
        } else if (handler == null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("No handler mapping found for [" + lookupPath + "]"));
        }
        return handler;
    }

    @Nullable
    protected Object lookupHandler(String urlPath, HttpServletRequest request) throws Exception {
        Object handler = this.handlerMap.get(urlPath);
        if (handler != null) {
            if (handler instanceof String) {
                String handlerName = (String)handler;
                handler = this.obtainApplicationContext().getBean(handlerName);
            }
            this.validateHandler(handler, request);
            return this.buildPathExposingHandler(handler, urlPath, urlPath, null);
        }
        ArrayList<String> matchingPatterns = new ArrayList<String>();
        for (String registeredPattern : this.handlerMap.keySet()) {
            if (this.getPathMatcher().match(registeredPattern, urlPath)) {
                matchingPatterns.add(registeredPattern);
                continue;
            }
            if (!this.useTrailingSlashMatch() || registeredPattern.endsWith("/") || !this.getPathMatcher().match(registeredPattern + "/", urlPath)) continue;
            matchingPatterns.add(registeredPattern + "/");
        }
        String bestMatch = null;
        Comparator patternComparator = this.getPathMatcher().getPatternComparator(urlPath);
        if (!matchingPatterns.isEmpty()) {
            Collections.sort(matchingPatterns, patternComparator);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Matching patterns for request [" + urlPath + "] are " + matchingPatterns));
            }
            bestMatch = (String)matchingPatterns.get(0);
        }
        if (bestMatch != null) {
            handler = this.handlerMap.get(bestMatch);
            if (handler == null) {
                if (bestMatch.endsWith("/")) {
                    handler = this.handlerMap.get(bestMatch.substring(0, bestMatch.length() - 1));
                }
                if (handler == null) {
                    throw new IllegalStateException("Could not find handler for best pattern match [" + bestMatch + "]");
                }
            }
            if (handler instanceof String) {
                String handlerName = (String)handler;
                handler = this.obtainApplicationContext().getBean(handlerName);
            }
            this.validateHandler(handler, request);
            String pathWithinMapping = this.getPathMatcher().extractPathWithinPattern(bestMatch, urlPath);
            LinkedHashMap<String, String> uriTemplateVariables = new LinkedHashMap<String, String>();
            for (String matchingPattern : matchingPatterns) {
                if (patternComparator.compare(bestMatch, matchingPattern) != 0) continue;
                Map vars = this.getPathMatcher().extractUriTemplateVariables(matchingPattern, urlPath);
                Map decodedVars = this.getUrlPathHelper().decodePathVariables(request, vars);
                uriTemplateVariables.putAll(decodedVars);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("URI Template variables for request [" + urlPath + "] are " + uriTemplateVariables));
            }
            return this.buildPathExposingHandler(handler, bestMatch, pathWithinMapping, uriTemplateVariables);
        }
        return null;
    }

    protected void validateHandler(Object handler, HttpServletRequest request) throws Exception {
    }

    protected Object buildPathExposingHandler(Object rawHandler, String bestMatchingPattern, String pathWithinMapping, @Nullable Map<String, String> uriTemplateVariables) {
        HandlerExecutionChain chain = new HandlerExecutionChain(rawHandler);
        chain.addInterceptor(new PathExposingHandlerInterceptor(bestMatchingPattern, pathWithinMapping));
        if (!CollectionUtils.isEmpty(uriTemplateVariables)) {
            chain.addInterceptor(new UriTemplateVariablesHandlerInterceptor(uriTemplateVariables));
        }
        return chain;
    }

    protected void exposePathWithinMapping(String bestMatchingPattern, String pathWithinMapping, HttpServletRequest request) {
        request.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, (Object)bestMatchingPattern);
        request.setAttribute(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)pathWithinMapping);
    }

    protected void exposeUriTemplateVariables(Map<String, String> uriTemplateVariables, HttpServletRequest request) {
        request.setAttribute(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriTemplateVariables);
    }

    @Override
    public RequestMatchResult match(HttpServletRequest request, String pattern) {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        if (this.getPathMatcher().match(pattern, lookupPath)) {
            return new RequestMatchResult(pattern, lookupPath, this.getPathMatcher());
        }
        if (this.useTrailingSlashMatch() && !pattern.endsWith("/") && this.getPathMatcher().match(pattern + "/", lookupPath)) {
            return new RequestMatchResult(pattern + "/", lookupPath, this.getPathMatcher());
        }
        return null;
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array must not be null");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Object mappedHandler;
        Assert.notNull((Object)urlPath, (String)"URL path must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            ApplicationContext applicationContext = this.obtainApplicationContext();
            if (applicationContext.isSingleton(handlerName)) {
                resolvedHandler = applicationContext.getBean(handlerName);
            }
        }
        if ((mappedHandler = this.handlerMap.get(urlPath)) != null) {
            if (mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map " + this.getHandlerDescription(handler) + " to URL path [" + urlPath + "]: There is already " + this.getHandlerDescription(mappedHandler) + " mapped.");
            }
        } else if (urlPath.equals("/")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Root mapping to " + this.getHandlerDescription(handler)));
            }
            this.setRootHandler(resolvedHandler);
        } else if (urlPath.equals("/*")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Default mapping to " + this.getHandlerDescription(handler)));
            }
            this.setDefaultHandler(resolvedHandler);
        } else {
            this.handlerMap.put(urlPath, resolvedHandler);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Mapped URL path [" + urlPath + "] onto " + this.getHandlerDescription(handler)));
            }
        }
    }

    private String getHandlerDescription(Object handler) {
        return "handler " + (handler instanceof String ? "'" + handler + "'" : "of type [" + handler.getClass() + "]");
    }

    public final Map<String, Object> getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }

    protected boolean supportsTypeLevelMappings() {
        return false;
    }

    private class UriTemplateVariablesHandlerInterceptor
    extends HandlerInterceptorAdapter {
        private final Map<String, String> uriTemplateVariables;

        public UriTemplateVariablesHandlerInterceptor(Map<String, String> uriTemplateVariables) {
            this.uriTemplateVariables = uriTemplateVariables;
        }

        @Override
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            AbstractUrlHandlerMapping.this.exposeUriTemplateVariables(this.uriTemplateVariables, request);
            return true;
        }
    }

    private class PathExposingHandlerInterceptor
    extends HandlerInterceptorAdapter {
        private final String bestMatchingPattern;
        private final String pathWithinMapping;

        public PathExposingHandlerInterceptor(String bestMatchingPattern, String pathWithinMapping) {
            this.bestMatchingPattern = bestMatchingPattern;
            this.pathWithinMapping = pathWithinMapping;
        }

        @Override
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            AbstractUrlHandlerMapping.this.exposePathWithinMapping(this.bestMatchingPattern, this.pathWithinMapping, request);
            request.setAttribute(HandlerMapping.INTROSPECT_TYPE_LEVEL_MAPPING, (Object)AbstractUrlHandlerMapping.this.supportsTypeLevelMappings());
            return true;
        }
    }
}

