/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=StreamingLimitationEventDeserializer.class)
class TrackLimitEvent {
    private final int numberOfLimitedTweets;

    private TrackLimitEvent(int numberOfLimitedTweets) {
        this.numberOfLimitedTweets = numberOfLimitedTweets;
    }

    public int getNumberOfLimitedTweets() {
        return this.numberOfLimitedTweets;
    }

    static final class StreamingLimitationEventDeserializer
    extends JsonDeserializer<TrackLimitEvent> {
        StreamingLimitationEventDeserializer() {
        }

        public TrackLimitEvent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode trackNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("limit").get("track");
            return new TrackLimitEvent(trackNode.asInt());
        }
    }
}

