/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.social.twitter.api.Place;
import org.springframework.social.twitter.api.PlaceType;
import org.springframework.social.twitter.api.impl.PlaceTypeDeserializer;
import org.springframework.social.twitter.api.impl.TwitterObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class PlaceMixin
extends TwitterObjectMixin {
    @JsonProperty(value="contained_within")
    List<Place> containedWithin;
    @JsonProperty(value="bounding_box")
    @JsonDeserialize(using=BoundingBoxDeserializer.class)
    List<Place.GeoPoint> boundingBox;
    @JsonProperty(value="geometry")
    @JsonDeserialize(using=GeometryDeserializer.class)
    Place.Geometry geometry;

    @JsonCreator
    public PlaceMixin(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="full_name") String fullName, @JsonProperty(value="attributes") @JsonDeserialize(using=StreetAddressDeserializer.class) String streetAddress, @JsonProperty(value="country") String country, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="place_type") @JsonDeserialize(using=PlaceTypeDeserializer.class) PlaceType placeType) {
    }

    private static class GeometryDeserializer
    extends JsonDeserializer<Place.Geometry> {
        private GeometryDeserializer() {
        }

        public Place.Geometry deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<List<Place.GeoPoint>> geoPoints = new ArrayList<List<Place.GeoPoint>>();
            List coordinatesList = null;
            String type = null;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = jp.getCurrentName();
                if ("coordinates".equals(fieldname)) {
                    jp.nextToken();
                    coordinatesList = (List)jp.readValueAs(new TypeReference<List<?>>(){});
                    continue;
                }
                if (!"type".equals(fieldname)) continue;
                jp.nextToken();
                type = jp.getText();
            }
            if ("Point".equals(type)) {
                this.setPoint(geoPoints, coordinatesList);
            } else if ("Polygon".equals(type)) {
                this.setPolygon(geoPoints, coordinatesList);
            } else if ("MultiPolygon".equals(type)) {
                this.setMultiPolygon(geoPoints, coordinatesList);
            }
            return new Place.Geometry(Place.GeometryType.valueOf(type.toUpperCase()), geoPoints);
        }

        private void setMultiPolygon(List<List<Place.GeoPoint>> geoPoints, List<?> coordinatesList) {
            for (Object o : coordinatesList) {
                List mCoordinatesList = (List)o;
                this.setPolygon(geoPoints, mCoordinatesList);
            }
        }

        private void setPolygon(List<List<Place.GeoPoint>> geoPoints, List<?> coordinatesList) {
            List polyCoords = (List)coordinatesList.get(0);
            ArrayList<Place.GeoPoint> polyPoints = new ArrayList<Place.GeoPoint>();
            for (List polyCoord : polyCoords) {
                double latitude = (Double)polyCoord.get(1);
                double longitude = (Double)polyCoord.get(0);
                polyPoints.add(new Place.GeoPoint(latitude, longitude));
            }
            geoPoints.add(polyPoints);
        }

        private void setPoint(List<List<Place.GeoPoint>> geoPoints, List<?> coordinatesList) {
            ArrayList<Place.GeoPoint> points = new ArrayList<Place.GeoPoint>();
            double latitude = Double.valueOf(String.valueOf(coordinatesList.get(1)));
            double longitude = Double.valueOf(String.valueOf(coordinatesList.get(0)));
            points.add(new Place.GeoPoint(latitude, longitude));
            geoPoints.add(points);
        }
    }

    private static class BoundingBoxDeserializer
    extends JsonDeserializer<List<Place.GeoPoint>> {
        private BoundingBoxDeserializer() {
        }

        public List<Place.GeoPoint> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Place.GeoPoint> points = new ArrayList<Place.GeoPoint>();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = jp.getCurrentName();
                if ("type".equals(fieldname)) {
                    jp.nextToken();
                }
                if (!"coordinates".equals(fieldname)) continue;
                jp.nextToken();
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    jp.nextToken();
                    double longitude = jp.getDoubleValue();
                    jp.nextToken();
                    double latitude = jp.getDoubleValue();
                    points.add(new Place.GeoPoint(latitude, longitude));
                    jp.nextToken();
                }
                jp.nextToken();
            }
            return points;
        }
    }

    private static class StreetAddressDeserializer
    extends JsonDeserializer<String> {
        private StreetAddressDeserializer() {
        }

        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Map attributesMap = (Map)jp.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            return attributesMap.containsKey("street_address") ? (String)attributesMap.get("street_address") : null;
        }
    }
}

