/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.Session;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;

final class RedisSessionExpirationPolicy {
    private static final Log logger = LogFactory.getLog(RedisSessionExpirationPolicy.class);
    private final RedisOperations<Object, Object> redis;
    private final RedisOperationsSessionRepository redisSession;

    RedisSessionExpirationPolicy(RedisOperations<Object, Object> sessionRedisOperations, RedisOperationsSessionRepository redisSession) {
        this.redis = sessionRedisOperations;
        this.redisSession = redisSession;
    }

    public void onDelete(Session session) {
        long toExpire = RedisSessionExpirationPolicy.roundUpToNextMinute(RedisSessionExpirationPolicy.expiresInMillis(session));
        String expireKey = this.getExpirationKey(toExpire);
        this.redis.boundSetOps((Object)expireKey).remove(new Object[]{session.getId()});
    }

    public void onExpirationUpdated(Long originalExpirationTimeInMilli, Session session) {
        long originalRoundedUp;
        String keyToExpire = "expires:" + session.getId();
        long toExpire = RedisSessionExpirationPolicy.roundUpToNextMinute(RedisSessionExpirationPolicy.expiresInMillis(session));
        if (originalExpirationTimeInMilli != null && toExpire != (originalRoundedUp = RedisSessionExpirationPolicy.roundUpToNextMinute(originalExpirationTimeInMilli))) {
            String expireKey = this.getExpirationKey(originalRoundedUp);
            this.redis.boundSetOps((Object)expireKey).remove(new Object[]{keyToExpire});
        }
        long sessionExpireInSeconds = session.getMaxInactiveInterval().getSeconds();
        String sessionKey = this.getSessionKey(keyToExpire);
        if (sessionExpireInSeconds < 0L) {
            this.redis.boundValueOps((Object)sessionKey).append("");
            this.redis.boundValueOps((Object)sessionKey).persist();
            this.redis.boundHashOps((Object)this.getSessionKey(session.getId())).persist();
            return;
        }
        String expireKey = this.getExpirationKey(toExpire);
        BoundSetOperations expireOperations = this.redis.boundSetOps((Object)expireKey);
        expireOperations.add(new Object[]{keyToExpire});
        long fiveMinutesAfterExpires = sessionExpireInSeconds + TimeUnit.MINUTES.toSeconds(5L);
        expireOperations.expire(fiveMinutesAfterExpires, TimeUnit.SECONDS);
        if (sessionExpireInSeconds == 0L) {
            this.redis.delete((Object)sessionKey);
        } else {
            this.redis.boundValueOps((Object)sessionKey).append("");
            this.redis.boundValueOps((Object)sessionKey).expire(sessionExpireInSeconds, TimeUnit.SECONDS);
        }
        this.redis.boundHashOps((Object)this.getSessionKey(session.getId())).expire(fiveMinutesAfterExpires, TimeUnit.SECONDS);
    }

    String getExpirationKey(long expires) {
        return this.redisSession.getExpirationsKey(expires);
    }

    String getSessionKey(String sessionId) {
        return this.redisSession.getSessionKey(sessionId);
    }

    public void cleanExpiredSessions() {
        long now = System.currentTimeMillis();
        long prevMin = RedisSessionExpirationPolicy.roundDownMinute(now);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up sessions expiring at " + new Date(prevMin)));
        }
        String expirationKey = this.getExpirationKey(prevMin);
        Set sessionsToExpire = this.redis.boundSetOps((Object)expirationKey).members();
        this.redis.delete((Object)expirationKey);
        for (Object session : sessionsToExpire) {
            String sessionKey = this.getSessionKey((String)session);
            this.touch(sessionKey);
        }
    }

    private void touch(String key) {
        this.redis.hasKey((Object)key);
    }

    static long expiresInMillis(Session session) {
        int maxInactiveInSeconds = (int)session.getMaxInactiveInterval().getSeconds();
        long lastAccessedTimeInMillis = session.getLastAccessedTime().toEpochMilli();
        return lastAccessedTimeInMillis + TimeUnit.SECONDS.toMillis(maxInactiveInSeconds);
    }

    static long roundUpToNextMinute(long timeInMs) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(timeInMs);
        date.add(12, 1);
        date.clear(13);
        date.clear(14);
        return date.getTimeInMillis();
    }

    static long roundDownMinute(long timeInMs) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(timeInMs);
        date.clear(13);
        date.clear(14);
        return date.getTimeInMillis();
    }
}

