/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import java.time.Duration;
import javax.annotation.PostConstruct;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.session.data.mongo.MongoSessionUtils;
import reactor.core.publisher.Mono;

public class ReactiveMongoOperationsSessionRepository
implements ReactiveSessionRepository<MongoSession> {
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private final ReactiveMongoOperations mongoOperations;
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String collectionName = "sessions";
    private AbstractMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));
    private MongoOperations blockingMongoOperations;

    public ReactiveMongoOperationsSessionRepository(ReactiveMongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public Mono<MongoSession> createSession() {
        return Mono.justOrEmpty((Object)this.maxInactiveIntervalInSeconds).map(MongoSession::new).switchIfEmpty(Mono.just((Object)new MongoSession()));
    }

    public Mono<Void> save(MongoSession session) {
        return this.mongoOperations.save((Object)MongoSessionUtils.convertToDBObject(this.mongoSessionConverter, session), this.collectionName).then();
    }

    public Mono<MongoSession> findById(String id) {
        return this.findSession(id).map(document -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, document)).filter(mongoSession -> !mongoSession.isExpired()).switchIfEmpty(Mono.defer(() -> this.deleteById(id).then(Mono.empty())));
    }

    public Mono<Void> deleteById(String id) {
        return this.mongoOperations.remove(this.findSession(id), this.collectionName).then();
    }

    @PostConstruct
    public void ensureIndexesAreCreated() {
        if (this.blockingMongoOperations != null) {
            IndexOperations indexOperations = this.blockingMongoOperations.indexOps(this.collectionName);
            this.mongoSessionConverter.ensureIndexes(indexOperations);
        }
    }

    private Mono<Document> findSession(String id) {
        return this.mongoOperations.findById((Object)id, Document.class, this.collectionName);
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public Integer getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public MongoOperations getBlockingMongoOperations() {
        return this.blockingMongoOperations;
    }

    public void setBlockingMongoOperations(MongoOperations blockingMongoOperations) {
        this.blockingMongoOperations = blockingMongoOperations;
    }
}

