/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.DBObject;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.session.data.mongo.MongoSessionUtils;

public class MongoOperationsSessionRepository
implements FindByIndexNameSessionRepository<MongoSession> {
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private final MongoOperations mongoOperations;
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String collectionName = "sessions";
    private AbstractMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));

    public MongoOperationsSessionRepository(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public MongoSession createSession() {
        MongoSession session = new MongoSession();
        if (this.maxInactiveIntervalInSeconds != null) {
            session.setMaxInactiveInterval(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));
        }
        return session;
    }

    public void save(MongoSession session) {
        DBObject sessionDbObject = MongoSessionUtils.convertToDBObject(this.mongoSessionConverter, session);
        this.mongoOperations.save((Object)sessionDbObject, this.collectionName);
    }

    public MongoSession findById(String id) {
        Document sessionWrapper = this.findSession(id);
        if (sessionWrapper == null) {
            return null;
        }
        MongoSession session = MongoSessionUtils.convertToSession(this.mongoSessionConverter, sessionWrapper);
        if (session.isExpired()) {
            this.deleteById(id);
            return null;
        }
        return session;
    }

    public Map<String, MongoSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        HashMap<String, MongoSession> result = new HashMap<String, MongoSession>();
        Query query = this.mongoSessionConverter.getQueryForIndex(indexName, indexValue);
        if (query == null) {
            return Collections.emptyMap();
        }
        List mapSessions = this.mongoOperations.find(query, Document.class, this.collectionName);
        for (Document dbSession : mapSessions) {
            MongoSession mapSession = MongoSessionUtils.convertToSession(this.mongoSessionConverter, dbSession);
            result.put(mapSession.getId(), mapSession);
        }
        return result;
    }

    public void deleteById(String id) {
        this.mongoOperations.remove((Object)this.findSession(id), this.collectionName);
    }

    @PostConstruct
    public void ensureIndexesAreCreated() {
        IndexOperations indexOperations = this.mongoOperations.indexOps(this.collectionName);
        this.mongoSessionConverter.ensureIndexes(indexOperations);
    }

    Document findSession(String id) {
        return (Document)this.mongoOperations.findById((Object)id, Document.class, this.collectionName);
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }
}

