/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.util.Collection;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeRequestRedirectFilter;
import org.springframework.security.oauth2.client.authentication.AuthorizationRequestUriBuilder;
import org.springframework.security.oauth2.client.authentication.DefaultAuthorizationRequestUriBuilder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;

final class AuthorizationCodeRequestRedirectFilterConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<AuthorizationCodeRequestRedirectFilterConfigurer<B>, B> {
    private AuthorizationRequestUriBuilder authorizationRequestBuilder;

    AuthorizationCodeRequestRedirectFilterConfigurer() {
    }

    AuthorizationCodeRequestRedirectFilterConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notEmpty((Collection)clientRegistrationRepository.getRegistrations(), (String)"clientRegistrationRepository cannot be empty");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    AuthorizationCodeRequestRedirectFilterConfigurer<B> authorizationRequestBuilder(AuthorizationRequestUriBuilder authorizationRequestBuilder) {
        Assert.notNull((Object)authorizationRequestBuilder, (String)"authorizationRequestBuilder cannot be null");
        this.authorizationRequestBuilder = authorizationRequestBuilder;
        return this;
    }

    @Override
    public void configure(B http) throws Exception {
        AuthorizationCodeRequestRedirectFilter filter = new AuthorizationCodeRequestRedirectFilter(OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()), this.getAuthorizationRequestBuilder());
        http.addFilter((Filter)this.postProcess(filter));
    }

    private AuthorizationRequestUriBuilder getAuthorizationRequestBuilder() {
        if (this.authorizationRequestBuilder == null) {
            this.authorizationRequestBuilder = new DefaultAuthorizationRequestUriBuilder();
        }
        return this.authorizationRequestBuilder;
    }
}

