/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.AuthorizationGrantTokenExchanger;
import org.springframework.security.oauth2.client.authentication.nimbus.NimbusAuthorizationCodeTokenExchanger;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.user.OAuth2UserService;
import org.springframework.security.oauth2.client.user.nimbus.NimbusOAuth2UserService;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

final class AuthorizationCodeAuthenticationFilterConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractAuthenticationFilterConfigurer<H, AuthorizationCodeAuthenticationFilterConfigurer<H>, AuthorizationCodeAuthenticationProcessingFilter> {
    private AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger;
    private OAuth2UserService userInfoService;
    private Map<URI, Function<ClientHttpResponse, ? extends OAuth2User>> userInfoTypeConverters = new HashMap<URI, Function<ClientHttpResponse, ? extends OAuth2User>>();

    AuthorizationCodeAuthenticationFilterConfigurer() {
        super(new AuthorizationCodeAuthenticationProcessingFilter(), null);
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notEmpty((Collection)clientRegistrationRepository.getRegistrations(), (String)"clientRegistrationRepository cannot be empty");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H> authorizationCodeTokenExchanger(AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger) {
        Assert.notNull(authorizationCodeTokenExchanger, (String)"authorizationCodeTokenExchanger cannot be null");
        this.authorizationCodeTokenExchanger = authorizationCodeTokenExchanger;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H> userInfoService(OAuth2UserService userInfoService) {
        Assert.notNull((Object)userInfoService, (String)"userInfoService cannot be null");
        this.userInfoService = userInfoService;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H> userInfoTypeConverter(Function<ClientHttpResponse, ? extends OAuth2User> userInfoConverter, URI userInfoUri) {
        Assert.notNull(userInfoConverter, (String)"userInfoConverter cannot be null");
        Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
        this.userInfoTypeConverters.put(userInfoUri, userInfoConverter);
        return this;
    }

    String getLoginUrl() {
        return super.getLoginPage();
    }

    String getLoginFailureUrl() {
        return super.getFailureUrl();
    }

    @Override
    public void init(H http) throws Exception {
        AuthorizationCodeAuthenticationProvider authenticationProvider = new AuthorizationCodeAuthenticationProvider(this.getAuthorizationCodeTokenExchanger(), this.getUserInfoService());
        authenticationProvider = this.postProcess(authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authenticationProvider);
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        AuthorizationCodeAuthenticationProcessingFilter authFilter = (AuthorizationCodeAuthenticationProcessingFilter)this.getAuthenticationFilter();
        authFilter.setClientRegistrationRepository(OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()));
        super.configure(http);
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return ((AuthorizationCodeAuthenticationProcessingFilter)this.getAuthenticationFilter()).getAuthorizeRequestMatcher();
    }

    private AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> getAuthorizationCodeTokenExchanger() {
        if (this.authorizationCodeTokenExchanger == null) {
            this.authorizationCodeTokenExchanger = new NimbusAuthorizationCodeTokenExchanger();
        }
        return this.authorizationCodeTokenExchanger;
    }

    private OAuth2UserService getUserInfoService() {
        if (this.userInfoService == null) {
            this.userInfoService = new NimbusOAuth2UserService(this.userInfoTypeConverters);
        }
        return this.userInfoService;
    }
}

