/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.util.IterableEnumeration;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class DocumentableHttpServletRequest {
    private final MockHttpServletRequest delegate;

    public DocumentableHttpServletRequest(MockHttpServletRequest request) {
        this.delegate = request;
    }

    public boolean isGetRequest() {
        return RequestMethod.GET == RequestMethod.valueOf((String)this.delegate.getMethod());
    }

    public boolean isPostRequest() {
        return RequestMethod.POST == RequestMethod.valueOf((String)this.delegate.getMethod());
    }

    public boolean isPutRequest() {
        return RequestMethod.PUT == RequestMethod.valueOf((String)this.delegate.getMethod());
    }

    public HttpHeaders getHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (String headerName : IterableEnumeration.iterable(this.delegate.getHeaderNames())) {
            for (String header : IterableEnumeration.iterable(this.delegate.getHeaders(headerName))) {
                httpHeaders.add(headerName, header);
            }
        }
        return httpHeaders;
    }

    public String getScheme() {
        return this.delegate.getScheme();
    }

    public String getHost() {
        return this.delegate.getServerName();
    }

    public int getPort() {
        return this.delegate.getServerPort();
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public long getContentLength() {
        return this.delegate.getContentLengthLong();
    }

    public String getContentAsString() throws IOException {
        StringWriter bodyWriter = new StringWriter();
        FileCopyUtils.copy((Reader)this.delegate.getReader(), (Writer)bodyWriter);
        return bodyWriter.toString();
    }

    public String getRequestUriWithQueryString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.delegate.getRequestURI());
        String queryString = this.getQueryString();
        if (StringUtils.hasText((String)queryString)) {
            sb.append('?').append(queryString);
        }
        return sb.toString();
    }

    public String getParameterMapAsQueryString() {
        return DocumentableHttpServletRequest.toQueryString(this.delegate.getParameterMap());
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    private String getQueryString() {
        if (this.delegate.getQueryString() != null) {
            return this.delegate.getQueryString();
        }
        if (this.isGetRequest()) {
            return this.getParameterMapAsQueryString();
        }
        return null;
    }

    private static String toQueryString(Map<String, String[]> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            for (String value : entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(DocumentableHttpServletRequest.urlEncodeUTF8(entry.getKey())).append('=').append(DocumentableHttpServletRequest.urlEncodeUTF8(value));
            }
        }
        return sb.toString();
    }

    private static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to URL encode " + s + " using UTF-8", ex);
        }
    }
}

