/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.KafkaMessageHeaders;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

public class BatchMessagingMessageConverter
implements BatchMessageConverter {
    private boolean generateMessageId = false;
    private boolean generateTimestamp = false;

    public void setGenerateMessageId(boolean generateMessageId) {
        this.generateMessageId = generateMessageId;
    }

    public void setGenerateTimestamp(boolean generateTimestamp) {
        this.generateTimestamp = generateTimestamp;
    }

    @Override
    public Message<?> toMessage(List<ConsumerRecord<?, ?>> records, Acknowledgment acknowledgment, Consumer<?, ?> consumer, Type type) {
        KafkaMessageHeaders kafkaMessageHeaders = new KafkaMessageHeaders(this.generateMessageId, this.generateTimestamp);
        Map<String, Object> rawHeaders = kafkaMessageHeaders.getRawHeaders();
        ArrayList<Object> payloads = new ArrayList<Object>();
        ArrayList<Object> keys = new ArrayList<Object>();
        ArrayList<String> topics = new ArrayList<String>();
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        ArrayList<String> timestampTypes = new ArrayList<String>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        rawHeaders.put("kafka_receivedMessageKey", keys);
        rawHeaders.put("kafka_receivedTopic", topics);
        rawHeaders.put("kafka_receivedPartitionId", partitions);
        rawHeaders.put("kafka_offset", offsets);
        rawHeaders.put("kafka_timestampType", timestampTypes);
        rawHeaders.put("kafka_receivedTimestamp", timestamps);
        if (acknowledgment != null) {
            rawHeaders.put("kafka_acknowledgment", acknowledgment);
        }
        if (consumer != null) {
            rawHeaders.put("kafka_consumer", consumer);
        }
        for (ConsumerRecord<?, ?> record : records) {
            payloads.add(this.extractAndConvertValue(record, type));
            keys.add(record.key());
            topics.add(record.topic());
            partitions.add(record.partition());
            offsets.add(record.offset());
            timestampTypes.add(record.timestampType().name());
            timestamps.add(record.timestamp());
        }
        return MessageBuilder.createMessage(payloads, (MessageHeaders)kafkaMessageHeaders);
    }

    @Override
    public List<ProducerRecord<?, ?>> fromMessage(Message<?> message, String defaultTopic) {
        throw new UnsupportedOperationException();
    }

    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        return record.value() == null ? KafkaNull.INSTANCE : record.value();
    }
}

