/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.ConsumerSeekAware;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.FilteringMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.RetryingMessageListenerAdapter;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class AbstractKafkaListenerEndpoint<K, V>
implements KafkaListenerEndpoint,
BeanFactoryAware,
InitializingBean {
    private String id;
    private final Collection<String> topics = new ArrayList<String>();
    private Pattern topicPattern;
    private final Collection<TopicPartitionInitialOffset> topicPartitions = new ArrayList<TopicPartitionInitialOffset>();
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private BeanResolver beanResolver;
    private String group;
    private RecordFilterStrategy<K, V> recordFilterStrategy;
    private boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private boolean batchListener;
    private KafkaTemplate<K, V> replyTemplate;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    protected BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    protected BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public Collection<String> getTopics() {
        return Collections.unmodifiableCollection(this.topics);
    }

    public void setTopicPartitions(TopicPartitionInitialOffset ... topicPartitions) {
        Assert.notNull((Object)topicPartitions, (String)"'topics' must not be null");
        this.topicPartitions.clear();
        this.topicPartitions.addAll(Arrays.asList(topicPartitions));
    }

    @Override
    public Collection<TopicPartitionInitialOffset> getTopicPartitions() {
        return Collections.unmodifiableCollection(this.topicPartitions);
    }

    public void setTopicPattern(Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    public Pattern getTopicPattern() {
        return this.topicPattern;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setReplyTemplate(KafkaTemplate<K, V> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    protected KafkaTemplate<K, V> getReplyTemplate() {
        return this.replyTemplate;
    }

    protected RecordFilterStrategy<K, V> getRecordFilterStrategy() {
        return this.recordFilterStrategy;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<K, V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    protected boolean isAckDiscarded() {
        return this.ackDiscarded;
    }

    public void setAckDiscarded(boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    protected RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    protected RecoveryCallback<?> getRecoveryCallback() {
        return this.recoveryCallback;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void afterPropertiesSet() {
        boolean topicsEmpty = this.getTopics().isEmpty();
        boolean topicPartitionsEmpty = this.getTopicPartitions().isEmpty();
        if (!topicsEmpty && !topicPartitionsEmpty) {
            throw new IllegalStateException("Topics or topicPartitions must be provided but not both for " + this);
        }
        if (!(this.topicPattern == null || topicsEmpty && topicPartitionsEmpty)) {
            throw new IllegalStateException("Only one of topics, topicPartitions or topicPattern must are allowed for " + this);
        }
        if (this.topicPattern == null && topicsEmpty && topicPartitionsEmpty) {
            throw new IllegalStateException("At least one of topics, topicPartitions or topicPattern must be provided for " + this);
        }
    }

    @Override
    public void setupListenerContainer(MessageListenerContainer listenerContainer, MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    protected abstract MessagingMessageListenerAdapter<K, V> createMessageListener(MessageListenerContainer var1, MessageConverter var2);

    private void setupMessageListener(MessageListenerContainer container, MessageConverter messageConverter) {
        ConsumerSeekAware messageListener = this.createMessageListener(container, messageConverter);
        Assert.state((messageListener != null ? 1 : 0) != 0, (String)("Endpoint [" + this + "] must provide a non null message listener"));
        if (this.retryTemplate != null) {
            messageListener = new RetryingMessageListenerAdapter((MessageListener)((Object)messageListener), this.retryTemplate, this.recoveryCallback);
        }
        if (this.recordFilterStrategy != null) {
            messageListener = new FilteringMessageListenerAdapter<K, V>((MessageListener)((Object)messageListener), this.recordFilterStrategy, this.ackDiscarded);
        }
        container.setupMessageListener(messageListener);
    }

    protected StringBuilder getEndpointDescription() {
        StringBuilder result = new StringBuilder();
        return result.append(this.getClass().getSimpleName()).append("[").append(this.id).append("] topics=").append(this.topics).append("' | topicPartitions='").append(this.topicPartitions).append("' | topicPattern='").append(this.topicPattern).append("'");
    }

    public String toString() {
        return this.getEndpointDescription().toString();
    }
}

