/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.regex.Pattern;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;

public abstract class AbstractKafkaListenerContainerFactory<C extends AbstractMessageListenerContainer<K, V>, K, V>
implements KafkaListenerContainerFactory<C>,
ApplicationEventPublisherAware {
    private final ContainerProperties containerProperties = new ContainerProperties((Pattern)null);
    private ConsumerFactory<K, V> consumerFactory;
    private Boolean autoStartup;
    private Integer phase;
    private MessageConverter messageConverter;
    private RecordFilterStrategy<K, V> recordFilterStrategy;
    private Boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private Boolean batchListener;
    private ApplicationEventPublisher applicationEventPublisher;
    private KafkaTemplate<K, V> replyTemplate;

    public void setConsumerFactory(ConsumerFactory<K, V> consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public ConsumerFactory<K, V> getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<K, V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    public void setAckDiscarded(Boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public Boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(Boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setReplyTemplate(KafkaTemplate<K, V> replyTemplate) {
        this.replyTemplate = replyTemplate;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public C createListenerContainer(KafkaListenerEndpoint endpoint) {
        C instance = this.createContainerInstance(endpoint);
        if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        if (this.phase != null) {
            ((AbstractMessageListenerContainer)instance).setPhase(this.phase);
        }
        if (this.applicationEventPublisher != null) {
            ((AbstractMessageListenerContainer)instance).setApplicationEventPublisher(this.applicationEventPublisher);
        }
        if (endpoint.getId() != null) {
            ((AbstractMessageListenerContainer)instance).setBeanName(endpoint.getId());
        }
        if (endpoint instanceof AbstractKafkaListenerEndpoint) {
            AbstractKafkaListenerEndpoint aklEndpoint = (AbstractKafkaListenerEndpoint)endpoint;
            if (this.recordFilterStrategy != null) {
                aklEndpoint.setRecordFilterStrategy(this.recordFilterStrategy);
            }
            if (this.ackDiscarded != null) {
                aklEndpoint.setAckDiscarded(this.ackDiscarded);
            }
            if (this.retryTemplate != null) {
                aklEndpoint.setRetryTemplate(this.retryTemplate);
            }
            if (this.recoveryCallback != null) {
                aklEndpoint.setRecoveryCallback(this.recoveryCallback);
            }
            if (this.batchListener != null) {
                aklEndpoint.setBatchListener(this.batchListener);
            }
            if (this.replyTemplate != null) {
                aklEndpoint.setReplyTemplate(this.replyTemplate);
            }
        }
        endpoint.setupListenerContainer((MessageListenerContainer)instance, this.messageConverter);
        this.initializeContainer(instance);
        return instance;
    }

    protected abstract C createContainerInstance(KafkaListenerEndpoint var1);

    protected void initializeContainer(C instance) {
        ContainerProperties properties = ((AbstractMessageListenerContainer)instance).getContainerProperties();
        BeanUtils.copyProperties((Object)this.containerProperties, (Object)properties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "messageListener", "ackCount", "ackTime"});
        if (this.containerProperties.getAckCount() > 0) {
            properties.setAckCount(this.containerProperties.getAckCount());
        }
        if (this.containerProperties.getAckTime() > 0L) {
            properties.setAckTime(this.containerProperties.getAckTime());
        }
    }
}

