/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.context;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.kafka.test.rule.KafkaEmbedded;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

class EmbeddedKafkaContextCustomizer
implements ContextCustomizer {
    private final EmbeddedKafka embeddedKafka;

    EmbeddedKafkaContextCustomizer(EmbeddedKafka embeddedKafka) {
        this.embeddedKafka = embeddedKafka;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(DefaultSingletonBeanRegistry.class, (Object)beanFactory);
        KafkaEmbedded kafkaEmbedded = new KafkaEmbedded(this.embeddedKafka.count(), this.embeddedKafka.controlledShutdown(), this.embeddedKafka.partitions(), this.embeddedKafka.topics());
        beanFactory.initializeBean((Object)kafkaEmbedded, "kafkaEmbedded");
        beanFactory.registerSingleton("kafkaEmbedded", (Object)kafkaEmbedded);
        ((DefaultSingletonBeanRegistry)beanFactory).registerDisposableBean("kafkaEmbedded", (DisposableBean)kafkaEmbedded);
    }
}

