/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageHandlerSpec;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.integration.kafka.support.KafkaProducerContext;
import org.springframework.integration.kafka.support.ProducerConfiguration;
import org.springframework.integration.kafka.support.ProducerFactoryBean;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class KafkaProducerMessageHandlerSpec
extends MessageHandlerSpec<KafkaProducerMessageHandlerSpec, KafkaProducerMessageHandler>
implements ComponentsRegistration {
    private final KafkaProducerContext kafkaProducerContext;
    private final Properties producerProperties;
    private final Map<String, ProducerConfiguration<?, ?>> producerConfigurations = new HashMap();

    KafkaProducerMessageHandlerSpec(Properties producerProperties) {
        this.producerProperties = producerProperties;
        this.kafkaProducerContext = new KafkaProducerContext();
        this.kafkaProducerContext.setBeanName(null);
        this.target = new KafkaProducerMessageHandler(this.kafkaProducerContext);
    }

    public KafkaProducerMessageHandlerSpec topic(String topic) {
        return this.topicExpression((Expression)new LiteralExpression(topic));
    }

    public KafkaProducerMessageHandlerSpec topicExpression(String topicExpression) {
        return this.topicExpression(PARSER.parseExpression(topicExpression));
    }

    public KafkaProducerMessageHandlerSpec topicExpression(Expression topicExpression) {
        ((KafkaProducerMessageHandler)this.target).setTopicExpression(topicExpression);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public <P> KafkaProducerMessageHandlerSpec topic(Function<Message<P>, String> topicFunction) {
        return this.topicExpression(new FunctionExpression<Message<P>>(topicFunction));
    }

    public KafkaProducerMessageHandlerSpec messageKeyExpression(String messageKeyExpression) {
        return this.messageKeyExpression(PARSER.parseExpression(messageKeyExpression));
    }

    public KafkaProducerMessageHandlerSpec messageKey(String messageKey) {
        return this.messageKeyExpression((Expression)new LiteralExpression(messageKey));
    }

    public KafkaProducerMessageHandlerSpec messageKeyExpression(Expression messageKeyExpression) {
        ((KafkaProducerMessageHandler)this.target).setMessageKeyExpression(messageKeyExpression);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public <P> KafkaProducerMessageHandlerSpec messageKey(Function<Message<P>, ?> messageKeyFunction) {
        return this.messageKeyExpression(new FunctionExpression<Message<P>>(messageKeyFunction));
    }

    public KafkaProducerMessageHandlerSpec partitionId(Integer partitionId) {
        return this.partitionIdExpression((Expression)new ValueExpression((Object)partitionId));
    }

    public KafkaProducerMessageHandlerSpec partitionIdExpression(String partitionIdExpression) {
        return this.partitionIdExpression(PARSER.parseExpression(partitionIdExpression));
    }

    public <P> KafkaProducerMessageHandlerSpec partitionId(Function<Message<P>, Integer> partitionIdFunction) {
        return this.partitionIdExpression(new FunctionExpression<Message<P>>(partitionIdFunction));
    }

    public KafkaProducerMessageHandlerSpec partitionIdExpression(Expression partitionIdExpression) {
        ((KafkaProducerMessageHandler)this.target).setPartitionIdExpression(partitionIdExpression);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public KafkaProducerMessageHandlerSpec addProducer(ProducerMetadata producerMetadata, String brokerList) {
        Assert.notNull((Object)producerMetadata);
        Assert.hasText((String)brokerList);
        try {
            ProducerFactoryBean producerFactoryBean = new ProducerFactoryBean(producerMetadata, brokerList, this.producerProperties);
            Producer producer = producerFactoryBean.getObject();
            this.producerConfigurations.put(producerMetadata.getTopic(), new ProducerConfiguration(producerMetadata, producer));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    public KafkaProducerMessageHandlerSpec addProducer(ProducerConfiguration producerConfiguration) {
        Assert.notNull((Object)producerConfiguration);
        this.producerConfigurations.put(producerConfiguration.getProducerMetadata().getTopic(), producerConfiguration);
        return (KafkaProducerMessageHandlerSpec)this._this();
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        this.kafkaProducerContext.setProducerConfigurations(this.producerConfigurations);
        return Collections.singleton(this.kafkaProducerContext);
    }
}

