/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.kafka.Kafka09MessageDrivenChannelAdapter;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.util.Assert;

public class Kafka09MessageDrivenChannelAdapterSpec<K, V, S extends Kafka09MessageDrivenChannelAdapterSpec<K, V, S>>
extends MessageProducerSpec<S, Kafka09MessageDrivenChannelAdapter<K, V>> {
    Kafka09MessageDrivenChannelAdapterSpec(AbstractMessageListenerContainer<K, V> messageListenerContainer) {
        super(new Kafka09MessageDrivenChannelAdapter<K, V>(messageListenerContainer));
    }

    public static class KafkaMessageListenerContainerSpec<K, V> {
        private final ConcurrentMessageListenerContainer<K, V> container;
        private final ContainerProperties containerProperties;

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            this.container = new ConcurrentMessageListenerContainer(consumerFactory, this.containerProperties);
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, TopicPartitionInitialOffset ... topicPartitions) {
            this(consumerFactory, new ContainerProperties(topicPartitions));
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, String ... topics) {
            this(consumerFactory, new ContainerProperties(topics));
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, Pattern topicPattern) {
            this(consumerFactory, new ContainerProperties(topicPattern));
        }

        public KafkaMessageListenerContainerSpec<K, V> concurrency(int concurrency) {
            this.container.setConcurrency(concurrency);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> errorHandler(ErrorHandler errorHandler) {
            this.containerProperties.setErrorHandler(errorHandler);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackMode(AbstractMessageListenerContainer.AckMode ackMode) {
            this.containerProperties.setAckMode(ackMode);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pollTimeout(long pollTimeout) {
            this.containerProperties.setPollTimeout(pollTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackCount(int count) {
            this.containerProperties.setAckCount(count);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackTime(long millis) {
            this.containerProperties.setAckTime(millis);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> consumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
            this.containerProperties.setConsumerTaskExecutor(consumerTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> listenerTaskExecutor(AsyncListenableTaskExecutor listenerTaskExecutor) {
            this.containerProperties.setListenerTaskExecutor(listenerTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pauseAfter(long pauseAfter) {
            this.containerProperties.setPauseAfter(pauseAfter);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pauseEnabled(boolean pauseEnabled) {
            this.containerProperties.setPauseEnabled(pauseEnabled);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> queueDepth(int queueDepth) {
            this.containerProperties.setQueueDepth(queueDepth);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> shutdownTimeout(long shutdownTimeout) {
            this.containerProperties.setShutdownTimeout(shutdownTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> consumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
            this.containerProperties.setConsumerRebalanceListener(consumerRebalanceListener);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> commitCallback(OffsetCommitCallback commitCallback) {
            this.containerProperties.setCommitCallback(commitCallback);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> syncCommits(boolean syncCommits) {
            this.containerProperties.setSyncCommits(syncCommits);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> idleEventInterval(Long idleEventInterval) {
            this.containerProperties.setIdleEventInterval(idleEventInterval);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackOnError(boolean ackOnError) {
            this.containerProperties.setAckOnError(ackOnError);
            return this;
        }
    }

    public static class KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>
    extends Kafka09MessageDrivenChannelAdapterSpec<K, V, KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>>
    implements ComponentsRegistration {
        private KafkaMessageListenerContainerSpec<K, V> spec;

        KafkaMessageDrivenChannelAdapterListenerContainerSpec(KafkaMessageListenerContainerSpec<K, V> spec) {
            super(((KafkaMessageListenerContainerSpec)spec).container);
            this.spec = spec;
        }

        public KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> configureListenerContainer(Consumer<KafkaMessageListenerContainerSpec<K, V>> configurer) {
            Assert.notNull(configurer);
            configurer.accept(this.spec);
            return (KafkaMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        @Override
        public Collection<Object> getComponentsToRegister() {
            return Collections.singleton(((KafkaMessageListenerContainerSpec)this.spec).container);
        }
    }
}

