/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.Lifecycle;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public final class IntegrationFlowContext
implements BeanFactoryAware {
    private final Map<String, IntegrationFlow> registry = new HashMap<String, IntegrationFlow>();
    private final Map<String, MessageChannel> flowInputChannelCache = new ConcurrentHashMap<String, MessageChannel>();
    private ConfigurableListableBeanFactory beanFactory;

    private IntegrationFlowContext() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"To use Spring Integration Java DSL the 'beanFactory' has to be an instance of 'ConfigurableListableBeanFactory'. Consider using 'GenericApplicationContext' implementation.");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public String register(IntegrationFlow integrationFlow) {
        return this.register(integrationFlow, true);
    }

    public String register(IntegrationFlow integrationFlow, boolean autoStartup) {
        String id = this.generateBeanName(integrationFlow);
        this.register(id, integrationFlow, autoStartup);
        return id;
    }

    public void register(String flowId, IntegrationFlow integrationFlow) {
        this.register(flowId, integrationFlow, true);
    }

    public void register(String flowId, IntegrationFlow integrationFlow, boolean autoStartup) {
        IntegrationFlow theFlow = (IntegrationFlow)this.beanFactory.initializeBean((Object)integrationFlow, flowId);
        this.beanFactory.registerSingleton(flowId, (Object)theFlow);
        if (autoStartup) {
            if (theFlow instanceof Lifecycle) {
                ((Lifecycle)theFlow).start();
            } else {
                throw new IllegalStateException("For 'autoStartup' mode the 'IntegrationFlow' must be an instance of 'Lifecycle'.\nConsider to implement it for [" + integrationFlow + "]. Or start dependent components on their own.");
            }
        }
        this.registry.put(flowId, theFlow);
    }

    public synchronized void remove(String flowId) {
        if (this.registry.containsKey(flowId)) {
            IntegrationFlow theFlow = this.registry.remove(flowId);
            if (theFlow instanceof Lifecycle) {
                ((Lifecycle)theFlow).stop();
            }
        } else {
            throw new IllegalStateException("Only manually registered IntegrationFlows can be removed. But [" + flowId + "] ins't one of them.");
        }
        ((DefaultSingletonBeanRegistry)this.beanFactory).destroySingleton(flowId);
        this.flowInputChannelCache.remove(flowId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessagingTemplate messagingTemplateFor(String flowId) {
        MessageChannel channel = this.flowInputChannelCache.get(flowId);
        if (channel == null) {
            IntegrationFlow o = this.registry.get(flowId);
            if (!(o instanceof StandardIntegrationFlow)) throw new IllegalStateException("Only 'StandardIntegrationFlow' instances (e.g. extracted from 'IntegrationFlow' Lambdas) can be used for direct 'send' operation. But [" + o + "] ins't one of them.\nConsider 'BeanFactory.getBean()' usage for sending messages to the required 'MessageChannel'.");
            StandardIntegrationFlow integrationFlow = (StandardIntegrationFlow)o;
            Object next = integrationFlow.getIntegrationComponents().iterator().next();
            if (!(next instanceof MessageChannel)) throw new IllegalStateException("The 'IntegrationFlow' [" + integrationFlow + "] doesn't start with 'MessageChannel' for direct message sending.");
            channel = (MessageChannel)next;
            this.flowInputChannelCache.put(flowId, channel);
        }
        MessagingTemplate messagingTemplate = new MessagingTemplate(channel){

            public Message<?> receive() {
                return this.receiveAndConvert(Message.class);
            }

            public <T> T receiveAndConvert(Class<T> targetClass) {
                throw new UnsupportedOperationException("The 'receive()/receiveAndConvert()' isn't supported on the 'IntegrationFlow' input channel.");
            }
        };
        messagingTemplate.setBeanFactory((BeanFactory)this.beanFactory);
        return messagingTemplate;
    }

    private String generateBeanName(Object instance) {
        if (instance instanceof NamedComponent && ((NamedComponent)instance).getComponentName() != null) {
            return ((NamedComponent)instance).getComponentName();
        }
        String generatedBeanName = instance.getClass().getName();
        String id = instance.getClass().getName();
        int counter = -1;
        while (counter == -1 || this.beanFactory.containsBean(id)) {
            id = generatedBeanName + "#" + ++counter;
        }
        return id;
    }
}

