/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.util.Comparator;
import javax.jms.ConnectionFactory;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.core.io.Resource;
import org.springframework.integration.dsl.file.FileInboundChannelAdapterSpec;
import org.springframework.integration.dsl.file.Files;
import org.springframework.integration.dsl.ftp.Ftp;
import org.springframework.integration.dsl.ftp.FtpInboundChannelAdapterSpec;
import org.springframework.integration.dsl.jms.Jms;
import org.springframework.integration.dsl.jms.JmsInboundChannelAdapterSpec;
import org.springframework.integration.dsl.mail.ImapMailInboundChannelAdapterSpec;
import org.springframework.integration.dsl.mail.Mail;
import org.springframework.integration.dsl.mail.Pop3MailInboundChannelAdapterSpec;
import org.springframework.integration.dsl.scripting.ScriptMessageSourceSpec;
import org.springframework.integration.dsl.sftp.Sftp;
import org.springframework.integration.dsl.sftp.SftpInboundChannelAdapterSpec;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.jms.core.JmsTemplate;

public class MessageSources {
    public FileInboundChannelAdapterSpec file(File directory) {
        return this.file(directory, null);
    }

    public FileInboundChannelAdapterSpec file(File directory, Comparator<File> receptionOrderComparator) {
        return Files.inboundAdapter(directory, receptionOrderComparator);
    }

    public FtpInboundChannelAdapterSpec ftp(SessionFactory<FTPFile> sessionFactory) {
        return this.ftp(sessionFactory, null);
    }

    public FtpInboundChannelAdapterSpec ftp(SessionFactory<FTPFile> sessionFactory, Comparator<File> receptionOrderComparator) {
        return Ftp.inboundAdapter(sessionFactory, receptionOrderComparator);
    }

    public SftpInboundChannelAdapterSpec sftp(SessionFactory<ChannelSftp.LsEntry> sessionFactory) {
        return this.sftp(sessionFactory, null);
    }

    public SftpInboundChannelAdapterSpec sftp(SessionFactory<ChannelSftp.LsEntry> sessionFactory, Comparator<File> receptionOrderComparator) {
        return Sftp.inboundAdapter(sessionFactory, receptionOrderComparator);
    }

    public JmsInboundChannelAdapterSpec<? extends JmsInboundChannelAdapterSpec<?>> jms(JmsTemplate jmsTemplate) {
        return Jms.inboundAdapter(jmsTemplate);
    }

    public JmsInboundChannelAdapterSpec.JmsInboundChannelSpecTemplateAware jms(ConnectionFactory connectionFactory) {
        return Jms.inboundAdapter(connectionFactory);
    }

    public ImapMailInboundChannelAdapterSpec imap() {
        return Mail.imapInboundAdapter();
    }

    public ImapMailInboundChannelAdapterSpec imap(String url) {
        return Mail.imapInboundAdapter(url);
    }

    public Pop3MailInboundChannelAdapterSpec pop3() {
        return Mail.pop3InboundAdapter();
    }

    public Pop3MailInboundChannelAdapterSpec pop3(String url) {
        return Mail.pop3InboundAdapter(url);
    }

    public Pop3MailInboundChannelAdapterSpec pop3(String host, String username, String password) {
        return this.pop3(host, -1, username, password);
    }

    public Pop3MailInboundChannelAdapterSpec pop3(String host, int port, String username, String password) {
        return Mail.pop3InboundAdapter(host, port, username, password);
    }

    public ScriptMessageSourceSpec script(Resource scriptResource) {
        return new ScriptMessageSourceSpec(scriptResource);
    }

    public ScriptMessageSourceSpec script(String scriptLocation) {
        return new ScriptMessageSourceSpec(scriptLocation);
    }

    MessageSources() {
    }
}

