/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.dsl.support.BeanNameMessageProcessor;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.dsl.support.MapBuilder;
import org.springframework.integration.dsl.support.StringStringMapBuilder;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.transformer.HeaderEnricher;
import org.springframework.integration.transformer.support.ExpressionEvaluatingHeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.StaticHeaderValueMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class HeaderEnricherSpec
extends IntegrationComponentSpec<HeaderEnricherSpec, HeaderEnricher> {
    private final Map<String, HeaderValueMessageProcessor<?>> headerToAdd = new HashMap();
    private final HeaderEnricher headerEnricher = new HeaderEnricher(this.headerToAdd);

    HeaderEnricherSpec() {
    }

    public HeaderEnricherSpec defaultOverwrite(boolean defaultOverwrite) {
        this.headerEnricher.setDefaultOverwrite(defaultOverwrite);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec shouldSkipNulls(boolean shouldSkipNulls) {
        this.headerEnricher.setShouldSkipNulls(shouldSkipNulls);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec messageProcessor(MessageProcessor<?> messageProcessor) {
        this.headerEnricher.setMessageProcessor(messageProcessor);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec messageProcessor(String expression) {
        return this.messageProcessor((MessageProcessor<?>)new ExpressionEvaluatingMessageProcessor(PARSER.parseExpression(expression)));
    }

    public HeaderEnricherSpec messageProcessor(String beanName, String methodName) {
        return this.messageProcessor(new BeanNameMessageProcessor(beanName, methodName));
    }

    public HeaderEnricherSpec headers(MapBuilder<?, String, Object> headers) {
        return this.headers(headers, null);
    }

    public HeaderEnricherSpec headers(MapBuilder<?, String, Object> headers, Boolean overwrite) {
        Assert.notNull(headers);
        return this.headers(headers.get(), overwrite);
    }

    public HeaderEnricherSpec headers(Map<String, Object> headers) {
        return this.headers(headers, null);
    }

    public HeaderEnricherSpec headers(Map<String, Object> headers, Boolean overwrite) {
        Assert.notNull(headers);
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Expression) {
                ExpressionEvaluatingHeaderValueMessageProcessor processor = new ExpressionEvaluatingHeaderValueMessageProcessor((Expression)value, null);
                processor.setOverwrite(overwrite);
                this.header(name, (HeaderValueMessageProcessor)processor);
                continue;
            }
            this.header(name, value, overwrite);
        }
        return this;
    }

    public HeaderEnricherSpec headerExpressions(MapBuilder<?, String, String> headers) {
        return this.headerExpressions(headers, null);
    }

    public HeaderEnricherSpec headerExpressions(MapBuilder<?, String, String> headers, Boolean overwrite) {
        Assert.notNull(headers);
        return this.headerExpressions(headers.get(), overwrite);
    }

    public HeaderEnricherSpec headerExpressions(Consumer<StringStringMapBuilder> configurer) {
        return this.headerExpressions(configurer, null);
    }

    public HeaderEnricherSpec headerExpressions(Consumer<StringStringMapBuilder> configurer, Boolean overwrite) {
        Assert.notNull(configurer);
        StringStringMapBuilder builder = new StringStringMapBuilder();
        configurer.accept(builder);
        return this.headerExpressions(builder.get(), overwrite);
    }

    public HeaderEnricherSpec headerExpressions(Map<String, String> headers) {
        return this.headerExpressions(headers, null);
    }

    public HeaderEnricherSpec headerExpressions(Map<String, String> headers, Boolean overwrite) {
        Assert.notNull(headers);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ExpressionEvaluatingHeaderValueMessageProcessor processor = new ExpressionEvaluatingHeaderValueMessageProcessor(entry.getValue(), null);
            processor.setOverwrite(overwrite);
            this.header(entry.getKey(), (HeaderValueMessageProcessor)processor);
        }
        return this;
    }

    public <V> HeaderEnricherSpec header(String name, V value) {
        return this.header(name, value, null);
    }

    public <V> HeaderEnricherSpec header(String name, V value, Boolean overwrite) {
        StaticHeaderValueMessageProcessor headerValueMessageProcessor = new StaticHeaderValueMessageProcessor(value);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor<V>)headerValueMessageProcessor);
    }

    public HeaderEnricherSpec headerExpression(String name, String expression) {
        return this.headerExpression(name, expression, null);
    }

    public HeaderEnricherSpec headerExpression(String name, String expression, Boolean overwrite) {
        Assert.hasText((String)expression);
        return this.headerExpression(name, PARSER.parseExpression(expression), overwrite);
    }

    public <P> HeaderEnricherSpec headerFunction(String name, Function<Message<P>, Object> function) {
        return this.headerFunction(name, function, null);
    }

    public <P> HeaderEnricherSpec headerFunction(String name, Function<Message<P>, Object> function, Boolean overwrite) {
        Assert.notNull(function);
        return this.headerExpression(name, new FunctionExpression<Message<P>>(function), overwrite);
    }

    private HeaderEnricherSpec headerExpression(String name, Expression expression, Boolean overwrite) {
        ExpressionEvaluatingHeaderValueMessageProcessor headerValueMessageProcessor = new ExpressionEvaluatingHeaderValueMessageProcessor(expression, null);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor)headerValueMessageProcessor);
    }

    public <V> HeaderEnricherSpec header(String name, HeaderValueMessageProcessor<V> headerValueMessageProcessor) {
        Assert.hasText((String)name);
        this.headerToAdd.put(name, headerValueMessageProcessor);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec headerChannelsToString() {
        return this.headerExpression("replyChannel", "@integrationHeaderChannelRegistry.channelToChannelName(headers.replyChannel)", (Boolean)true).headerExpression("errorChannel", "@integrationHeaderChannelRegistry.channelToChannelName(headers.errorChannel)", (Boolean)true);
    }

    @Override
    protected HeaderEnricher doGet() {
        return this.headerEnricher;
    }
}

