/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.InboundFileSynchronizer;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractInboundFileSynchronizer<F>
implements InboundFileSynchronizer,
BeanFactoryAware,
InitializingBean,
Closeable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RemoteFileTemplate<F> remoteFileTemplate;
    private volatile EvaluationContext evaluationContext;
    private volatile String remoteFileSeparator = "/";
    private volatile String temporaryFileSuffix = ".writing";
    private volatile Expression localFilenameGeneratorExpression;
    private volatile Expression remoteDirectoryExpression;
    private volatile FileListFilter<F> filter;
    private volatile boolean deleteRemoteFiles;
    private volatile boolean preserveTimestamp;
    private BeanFactory beanFactory;

    public AbstractInboundFileSynchronizer(SessionFactory<F> sessionFactory) {
        Assert.notNull(sessionFactory, (String)"sessionFactory must not be null");
        this.remoteFileTemplate = new RemoteFileTemplate<F>(sessionFactory);
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setLocalFilenameGeneratorExpression(Expression localFilenameGeneratorExpression) {
        Assert.notNull((Object)localFilenameGeneratorExpression, (String)"'localFilenameGeneratorExpression' must not be null");
        this.localFilenameGeneratorExpression = localFilenameGeneratorExpression;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectoryExpression = new LiteralExpression(remoteDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.doSetRemoteDirectoryExpression(remoteDirectoryExpression);
    }

    protected final void doSetRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"'remoteDirectoryExpression' must not be null");
        this.remoteDirectoryExpression = remoteDirectoryExpression;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.doSetFilter(filter);
    }

    protected final void doSetFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public final void afterPropertiesSet() {
        Assert.state((this.remoteDirectoryExpression != null ? 1 : 0) != 0, (String)"'remoteDirectoryExpression' must not be null");
        if (this.evaluationContext == null) {
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.beanFactory);
        }
        this.doInit();
    }

    protected void doInit() {
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    @Override
    public void close() throws IOException {
        if (this.filter instanceof Closeable) {
            ((Closeable)((Object)this.filter)).close();
        }
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory) {
        this.synchronizeToLocalDirectory(localDirectory, Integer.MIN_VALUE);
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory, int maxFetchSize) {
        if (maxFetchSize == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Max Fetch Size is zero - fetch to " + localDirectory.getAbsolutePath() + " ignored"));
            }
            return;
        }
        String remoteDirectory = (String)this.remoteDirectoryExpression.getValue(this.evaluationContext, String.class);
        try {
            int transferred = this.remoteFileTemplate.execute(session -> {
                Object[] files = session.list(remoteDirectory);
                if (!ObjectUtils.isEmpty((Object[])files)) {
                    List<Object> filteredFiles = this.filterFiles(files);
                    if (maxFetchSize >= 0 && filteredFiles.size() > maxFetchSize) {
                        this.rollbackFromFileToListEnd(filteredFiles, filteredFiles.get(maxFetchSize));
                        ArrayList<Object> newList = new ArrayList<Object>(maxFetchSize);
                        for (int i = 0; i < maxFetchSize; ++i) {
                            newList.add(filteredFiles.get(i));
                        }
                        filteredFiles = newList;
                    }
                    for (Object file : filteredFiles) {
                        try {
                            if (file == null) continue;
                            this.copyFileToLocalDirectory(remoteDirectory, file, localDirectory, session);
                        }
                        catch (RuntimeException e1) {
                            this.rollbackFromFileToListEnd(filteredFiles, file);
                            throw e1;
                        }
                        catch (IOException e2) {
                            this.rollbackFromFileToListEnd(filteredFiles, file);
                            throw e2;
                        }
                    }
                    return filteredFiles.size();
                }
                return 0;
            });
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(transferred + " files transferred"));
            }
        }
        catch (Exception e) {
            throw new MessagingException("Problem occurred while synchronizing remote to local directory", (Throwable)e);
        }
    }

    protected void rollbackFromFileToListEnd(List<F> filteredFiles, F file) {
        if (this.filter instanceof ReversibleFileListFilter) {
            ((ReversibleFileListFilter)this.filter).rollback(file, filteredFiles);
        }
    }

    protected void copyFileToLocalDirectory(String remoteDirectoryPath, F remoteFile, File localDirectory, Session<F> session) throws IOException {
        String remoteFilePath;
        String remoteFileName = this.getFilename(remoteFile);
        String localFileName = this.generateLocalFileName(remoteFileName);
        String string = remoteFilePath = remoteDirectoryPath != null ? remoteDirectoryPath + this.remoteFileSeparator + remoteFileName : remoteFileName;
        if (!this.isFile(remoteFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("cannot copy, not a file: " + remoteFilePath));
            }
            return;
        }
        long modified = this.getModified(remoteFile);
        File localFile = new File(localDirectory, localFileName);
        boolean exists = localFile.exists();
        if (!exists || this.preserveTimestamp && modified != localFile.lastModified()) {
            if (!exists && localFileName.replaceAll("/", Matcher.quoteReplacement(File.separator)).contains(File.separator)) {
                localFile.getParentFile().mkdirs();
            }
            String tempFileName = localFile.getAbsolutePath() + this.temporaryFileSuffix;
            File tempFile = new File(tempFileName);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            try {
                session.read(remoteFilePath, outputStream);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Exception exception) {}
            }
            if (tempFile.renameTo(localFile) && this.deleteRemoteFiles) {
                session.remove(remoteFilePath);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("deleted " + remoteFilePath));
                }
            }
            if (this.preserveTimestamp) {
                localFile.setLastModified(modified);
            }
        }
    }

    private String generateLocalFileName(String remoteFileName) {
        if (this.localFilenameGeneratorExpression != null) {
            return (String)this.localFilenameGeneratorExpression.getValue(this.evaluationContext, (Object)remoteFileName, String.class);
        }
        return remoteFileName;
    }

    protected abstract boolean isFile(F var1);

    protected abstract String getFilename(F var1);

    protected abstract long getModified(F var1);
}

