/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageSourceSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.file.filters.ExpressionFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizingMessageSource;

public abstract class RemoteFileInboundChannelAdapterSpec<F, S extends RemoteFileInboundChannelAdapterSpec<F, S, MS>, MS extends AbstractInboundFileSynchronizingMessageSource<F>>
extends MessageSourceSpec<S, MS>
implements ComponentsRegistration {
    protected final AbstractInboundFileSynchronizer<F> synchronizer;
    private ExpressionFileListFilter<F> expressionFileListFilter;

    protected RemoteFileInboundChannelAdapterSpec(AbstractInboundFileSynchronizer<F> synchronizer) {
        this.synchronizer = synchronizer;
    }

    public S autoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        ((AbstractInboundFileSynchronizingMessageSource)((Object)this.target)).setAutoCreateLocalDirectory(autoCreateLocalDirectory);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S localDirectory(File localDirectory) {
        ((AbstractInboundFileSynchronizingMessageSource)((Object)this.target)).setLocalDirectory(localDirectory);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S localFilter(FileListFilter<File> localFileListFilter) {
        ((AbstractInboundFileSynchronizingMessageSource)((Object)this.target)).setLocalFilter(localFileListFilter);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S remoteFileSeparator(String remoteFileSeparator) {
        this.synchronizer.setRemoteFileSeparator(remoteFileSeparator);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S localFilenameExpression(String localFilenameExpression) {
        return this.localFilenameExpression(PARSER.parseExpression(localFilenameExpression));
    }

    public S localFilename(Function<String, String> localFilenameFunction) {
        return this.localFilenameExpression((Expression)new FunctionExpression(localFilenameFunction));
    }

    public S localFilenameExpression(Expression localFilenameExpression) {
        this.synchronizer.setLocalFilenameGeneratorExpression(localFilenameExpression);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S temporaryFileSuffix(String temporaryFileSuffix) {
        this.synchronizer.setTemporaryFileSuffix(temporaryFileSuffix);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S remoteDirectory(String remoteDirectory) {
        this.synchronizer.setRemoteDirectory(remoteDirectory);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S remoteDirectoryExpression(Expression remoteDirectoryExpression) {
        this.synchronizer.setRemoteDirectoryExpression(remoteDirectoryExpression);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S filter(FileListFilter<F> filter) {
        this.synchronizer.setFilter(filter);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S filterExpression(String expression) {
        this.expressionFileListFilter = new ExpressionFileListFilter(expression);
        return this.filter(this.expressionFileListFilter);
    }

    public S filterFunction(Function<F, Boolean> filterFunction) {
        this.expressionFileListFilter = new ExpressionFileListFilter((Expression)new FunctionExpression(filterFunction));
        return this.filter(this.expressionFileListFilter);
    }

    public abstract S patternFilter(String var1);

    public abstract S regexFilter(String var1);

    public S deleteRemoteFiles(boolean deleteRemoteFiles) {
        this.synchronizer.setDeleteRemoteFiles(deleteRemoteFiles);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public S preserveTimestamp(boolean preserveTimestamp) {
        this.synchronizer.setPreserveTimestamp(preserveTimestamp);
        return (S)((Object)((RemoteFileInboundChannelAdapterSpec)this._this()));
    }

    public Map<Object, String> getComponentsToRegister() {
        LinkedHashMap<Object, String> componentsToRegister = new LinkedHashMap<Object, String>();
        componentsToRegister.put(this.synchronizer, null);
        if (this.expressionFileListFilter != null) {
            componentsToRegister.put(this.expressionFileListFilter, null);
        }
        return componentsToRegister;
    }
}

