/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.file.support.FileUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.MessageTriggerAction;
import org.springframework.integration.support.locks.DefaultLockRegistry;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.support.locks.PassThruLockRegistry;
import org.springframework.integration.util.WhileLockedProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileWritingMessageHandler
extends AbstractReplyProducingMessageHandler
implements Lifecycle,
MessageTriggerAction {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final long DEFAULT_FLUSH_INTERVAL = 30000L;
    private final Map<String, FileState> fileStates = new HashMap<String, FileState>();
    private volatile String temporaryFileSuffix = ".writing";
    private volatile boolean temporaryFileSuffixSet = false;
    private volatile FileExistsMode fileExistsMode = FileExistsMode.REPLACE;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private volatile FileNameGenerator fileNameGenerator = new DefaultFileNameGenerator();
    private volatile boolean fileNameGeneratorSet;
    private volatile StandardEvaluationContext evaluationContext;
    private final Expression destinationDirectoryExpression;
    private volatile boolean autoCreateDirectory = true;
    private volatile boolean deleteSourceFiles;
    private volatile Charset charset = Charset.defaultCharset();
    private volatile boolean expectReply = true;
    private volatile boolean appendNewLine = false;
    private volatile LockRegistry lockRegistry = new PassThruLockRegistry();
    private volatile int bufferSize = 8192;
    private volatile long flushInterval = 30000L;
    private volatile boolean flushWhenIdle = true;
    private volatile ScheduledFuture<?> flushTask;
    private volatile MessageFlushPredicate flushPredicate = new DefaultFlushPredicate();
    private volatile boolean preserveTimestamp;
    private Set<PosixFilePermission> permissions;

    public FileWritingMessageHandler(File destinationDirectory) {
        Assert.notNull((Object)destinationDirectory, (String)"Destination directory must not be null.");
        this.destinationDirectoryExpression = new LiteralExpression(destinationDirectory.getPath());
    }

    public FileWritingMessageHandler(Expression destinationDirectoryExpression) {
        Assert.notNull((Object)destinationDirectoryExpression, (String)"Destination directory expression must not be null.");
        this.destinationDirectoryExpression = destinationDirectoryExpression;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        Assert.notNull((Object)temporaryFileSuffix, (String)"'temporaryFileSuffix' must not be null");
        this.temporaryFileSuffix = temporaryFileSuffix;
        this.temporaryFileSuffixSet = true;
    }

    public void setFileExistsMode(FileExistsMode fileExistsMode) {
        Assert.notNull((Object)((Object)fileExistsMode), (String)"'fileExistsMode' must not be null.");
        this.fileExistsMode = fileExistsMode;
        if (FileExistsMode.APPEND.equals((Object)fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode)) {
            this.lockRegistry = this.lockRegistry instanceof PassThruLockRegistry ? new DefaultLockRegistry() : this.lockRegistry;
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setAppendNewLine(boolean appendNewLine) {
        this.appendNewLine = appendNewLine;
    }

    protected String getTemporaryFileSuffix() {
        return this.temporaryFileSuffix;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        Assert.notNull((Object)fileNameGenerator, (String)"FileNameGenerator must not be null");
        this.fileNameGenerator = fileNameGenerator;
        this.fileNameGeneratorSet = true;
    }

    public void setDeleteSourceFiles(boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setCharset(String charset) {
        Assert.notNull((Object)charset, (String)"charset must not be null");
        Assert.isTrue((boolean)Charset.isSupported(charset), (String)("Charset '" + charset + "' is not supported."));
        this.charset = Charset.forName(charset);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFlushInterval(long flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushWhenIdle(boolean flushWhenIdle) {
        this.flushWhenIdle = flushWhenIdle;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        super.setTaskScheduler(taskScheduler);
    }

    public void setFlushPredicate(MessageFlushPredicate flushPredicate) {
        Assert.notNull((Object)flushPredicate, (String)"'flushPredicate' cannot be null");
        this.flushPredicate = flushPredicate;
    }

    public void setPreserveTimestamp(boolean preserveTimestamp) {
        this.preserveTimestamp = preserveTimestamp;
    }

    public void setChmodOctal(String chmod) {
        Assert.notNull((Object)chmod, (String)"'chmod' cannot be null");
        this.setChmod(Integer.parseInt(chmod, 8));
    }

    public void setChmod(int chmod) {
        Assert.isTrue((chmod >= 0 && chmod <= 511 ? 1 : 0) != 0, (String)"'chmod' must be between 0 and 0777 (octal)");
        if (!FileUtils.IS_POSIX) {
            this.logger.error((Object)"'chmod' setting ignored - the file system does not support Posix attributes");
            return;
        }
        BitSet bits = BitSet.valueOf(new byte[]{(byte)chmod, (byte)(chmod >> 8)});
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        bits.stream().forEach(b -> {
            switch (b) {
                case 0: {
                    permissions.add(PosixFilePermission.OTHERS_EXECUTE);
                    break;
                }
                case 1: {
                    permissions.add(PosixFilePermission.OTHERS_WRITE);
                    break;
                }
                case 2: {
                    permissions.add(PosixFilePermission.OTHERS_READ);
                    break;
                }
                case 3: {
                    permissions.add(PosixFilePermission.GROUP_EXECUTE);
                    break;
                }
                case 4: {
                    permissions.add(PosixFilePermission.GROUP_WRITE);
                    break;
                }
                case 5: {
                    permissions.add(PosixFilePermission.GROUP_READ);
                    break;
                }
                case 6: {
                    permissions.add(PosixFilePermission.OWNER_EXECUTE);
                    break;
                }
                case 7: {
                    permissions.add(PosixFilePermission.OWNER_WRITE);
                    break;
                }
                case 8: {
                    permissions.add(PosixFilePermission.OWNER_READ);
                }
            }
        });
        this.permissions = permissions;
    }

    protected void doInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        if (this.destinationDirectoryExpression instanceof LiteralExpression) {
            File directory = new File((String)this.destinationDirectoryExpression.getValue((EvaluationContext)this.evaluationContext, null, String.class));
            this.validateDestinationDirectory(directory, this.autoCreateDirectory);
        }
        Assert.state((!this.temporaryFileSuffixSet || !FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && !FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode) ? 1 : 0) != 0, (String)"'temporaryFileSuffix' can not be set when appending to an existing file");
        if (!this.fileNameGeneratorSet && this.fileNameGenerator instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.fileNameGenerator).setBeanFactory(this.getBeanFactory());
        }
    }

    public void start() {
        if (this.flushTask == null && FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode)) {
            TaskScheduler taskScheduler = this.getTaskScheduler();
            Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"'taskScheduler' is required for FileExistsMode.APPEND_NO_FLUSH");
            this.flushTask = taskScheduler.scheduleAtFixedRate((Runnable)new Flusher(), this.flushInterval / 3L);
        }
    }

    public void stop() {
        if (this.flushTask != null) {
            this.flushTask.cancel(true);
            this.flushTask = null;
        }
        new Flusher().run();
    }

    public boolean isRunning() {
        return this.flushTask != null;
    }

    private void validateDestinationDirectory(File destinationDirectory, boolean autoCreateDirectory) {
        if (!destinationDirectory.exists() && autoCreateDirectory) {
            Assert.isTrue((boolean)destinationDirectory.mkdirs(), () -> "Destination directory [" + destinationDirectory + "] could not be created.");
        }
        Assert.isTrue((boolean)destinationDirectory.exists(), () -> "Destination directory [" + destinationDirectory + "] does not exist.");
        Assert.isTrue((boolean)destinationDirectory.isDirectory(), () -> "Destination path [" + destinationDirectory + "] does not point to a directory.");
        Assert.isTrue((boolean)Files.isWritable(destinationDirectory.toPath()), () -> "Destination directory [" + destinationDirectory + "] is not writable.");
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        boolean ignore;
        Assert.notNull(requestMessage, (String)"message must not be null");
        Object payload = requestMessage.getPayload();
        Assert.notNull((Object)payload, (String)"message payload must not be null");
        String generatedFileName = this.fileNameGenerator.generateFileName(requestMessage);
        File originalFileFromHeader = this.retrieveOriginalFileFromHeader(requestMessage);
        File destinationDirectoryToUse = this.evaluateDestinationDirectoryExpression(requestMessage);
        File tempFile = new File(destinationDirectoryToUse, generatedFileName + this.temporaryFileSuffix);
        File resultFile = new File(destinationDirectoryToUse, generatedFileName);
        boolean exists = resultFile.exists();
        if (exists && FileExistsMode.FAIL.equals((Object)this.fileExistsMode)) {
            throw new MessageHandlingException(requestMessage, "The destination file already exists at '" + resultFile.getAbsolutePath() + "'.");
        }
        Object timestamp = requestMessage.getHeaders().get((Object)"file_setModified");
        if (payload instanceof File) {
            timestamp = ((File)payload).lastModified();
        }
        boolean bl = ignore = FileExistsMode.IGNORE.equals((Object)this.fileExistsMode) && (exists || StringUtils.hasText((String)this.temporaryFileSuffix) && tempFile.exists()) || exists && FileExistsMode.REPLACE_IF_MODIFIED.equals((Object)this.fileExistsMode) && timestamp instanceof Number && ((Number)timestamp).longValue() == resultFile.lastModified();
        if (!ignore) {
            try {
                if (!exists && generatedFileName.replaceAll("/", Matcher.quoteReplacement(File.separator)).contains(File.separator)) {
                    resultFile.getParentFile().mkdirs();
                }
                if (payload instanceof File) {
                    resultFile = this.handleFileMessage((File)payload, tempFile, resultFile);
                } else if (payload instanceof InputStream) {
                    resultFile = this.handleInputStreamMessage((InputStream)payload, originalFileFromHeader, tempFile, resultFile);
                } else if (payload instanceof byte[]) {
                    resultFile = this.handleByteArrayMessage((byte[])payload, originalFileFromHeader, tempFile, resultFile);
                } else if (payload instanceof String) {
                    resultFile = this.handleStringMessage((String)payload, originalFileFromHeader, tempFile, resultFile);
                } else {
                    throw new IllegalArgumentException("unsupported Message payload type [" + payload.getClass().getName() + "]");
                }
                if (this.preserveTimestamp) {
                    if (timestamp instanceof Number) {
                        resultFile.setLastModified(((Number)timestamp).longValue());
                    } else if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("Could not set lastModified, header file_setModified must be a Number, not " + (timestamp == null ? "null" : timestamp.getClass())));
                    }
                }
            }
            catch (Exception e) {
                throw new MessageHandlingException(requestMessage, "failed to write Message payload to file", (Throwable)e);
            }
        }
        if (!this.expectReply) {
            return null;
        }
        if (resultFile != null && originalFileFromHeader == null && payload instanceof File) {
            return this.getMessageBuilderFactory().withPayload((Object)resultFile).setHeader("file_originalFile", payload);
        }
        return resultFile;
    }

    private File retrieveOriginalFileFromHeader(Message<?> message) {
        Object value = message.getHeaders().get((Object)"file_originalFile");
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File((String)value);
        }
        return null;
    }

    private File handleFileMessage(File sourceFile, File tempFile, File resultFile) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && this.deleteSourceFiles) {
            FileWritingMessageHandler.rename(sourceFile, resultFile);
            return resultFile;
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sourceFile));
        return this.handleInputStreamMessage(bis, sourceFile, tempFile, resultFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File handleInputStreamMessage(final InputStream sourceFileInputStream, File originalFile, File tempFile, File resultFile) throws IOException {
        boolean append;
        boolean bl = append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode) || FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        if (append) {
            final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
            final FileState state = this.getFileState(fileToWriteTo, false);
            WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void whileLocked() throws IOException {
                    BufferedOutputStream bos = null;
                    try {
                        bos = state != null ? state.stream : FileWritingMessageHandler.this.createOutputStream(fileToWriteTo, true);
                        byte[] buffer = new byte[4096];
                        int bytesRead = -1;
                        while ((bytesRead = sourceFileInputStream.read(buffer)) != -1) {
                            bos.write(buffer, 0, bytesRead);
                        }
                        if (FileWritingMessageHandler.this.appendNewLine) {
                            bos.write(LINE_SEPARATOR.getBytes());
                        }
                    }
                    finally {
                        try {
                            sourceFileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            if (state == null || FileWritingMessageHandler.this.flushTask == null) {
                                if (bos != null) {
                                    bos.close();
                                }
                                FileWritingMessageHandler.this.clearState(fileToWriteTo, state);
                            } else {
                                state.lastWrite = System.currentTimeMillis();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            whileLockedProcessor.doWhileLocked();
            this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
            return resultFile;
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(tempFile), this.bufferSize);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = sourceFileInputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
            if (this.appendNewLine) {
                bos.write(LINE_SEPARATOR.getBytes());
            }
            bos.flush();
        }
        finally {
            try {
                sourceFileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.cleanUpAfterCopy(tempFile, resultFile, originalFile);
        return resultFile;
    }

    private File handleByteArrayMessage(final byte[] bytes, File originalFile, File tempFile, File resultFile) throws IOException {
        final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        final FileState state = this.getFileState(fileToWriteTo, false);
        final boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode);
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                BufferedOutputStream bos = null;
                try {
                    bos = state != null ? state.stream : FileWritingMessageHandler.this.createOutputStream(fileToWriteTo, append);
                    bos.write(bytes);
                    if (FileWritingMessageHandler.this.appendNewLine) {
                        bos.write(LINE_SEPARATOR.getBytes());
                    }
                }
                finally {
                    try {
                        if (state == null || FileWritingMessageHandler.this.flushTask == null) {
                            if (bos != null) {
                                bos.close();
                            }
                            FileWritingMessageHandler.this.clearState(fileToWriteTo, state);
                        } else {
                            state.lastWrite = System.currentTimeMillis();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    private File handleStringMessage(final String content, File originalFile, File tempFile, File resultFile) throws IOException {
        final File fileToWriteTo = this.determineFileToWrite(resultFile, tempFile);
        final FileState state = this.getFileState(fileToWriteTo, true);
        final boolean append = FileExistsMode.APPEND.equals((Object)this.fileExistsMode);
        WhileLockedProcessor whileLockedProcessor = new WhileLockedProcessor(this.lockRegistry, fileToWriteTo.getAbsolutePath()){

            protected void whileLocked() throws IOException {
                BufferedWriter writer = null;
                try {
                    writer = state != null ? state.writer : FileWritingMessageHandler.this.createWriter(fileToWriteTo, append);
                    writer.write(content);
                    if (FileWritingMessageHandler.this.appendNewLine) {
                        writer.newLine();
                    }
                }
                finally {
                    try {
                        if (state == null || FileWritingMessageHandler.this.flushTask == null) {
                            if (writer != null) {
                                writer.close();
                            }
                            FileWritingMessageHandler.this.clearState(fileToWriteTo, state);
                        } else {
                            state.lastWrite = System.currentTimeMillis();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        whileLockedProcessor.doWhileLocked();
        this.cleanUpAfterCopy(fileToWriteTo, resultFile, originalFile);
        return resultFile;
    }

    private File determineFileToWrite(File resultFile, File tempFile) {
        File fileToWriteTo;
        switch (this.fileExistsMode) {
            case APPEND: 
            case APPEND_NO_FLUSH: {
                fileToWriteTo = resultFile;
                break;
            }
            case FAIL: 
            case IGNORE: 
            case REPLACE: 
            case REPLACE_IF_MODIFIED: {
                fileToWriteTo = tempFile;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported FileExistsMode: " + (Object)((Object)this.fileExistsMode));
            }
        }
        return fileToWriteTo;
    }

    private void cleanUpAfterCopy(File fileToWriteTo, File resultFile, File originalFile) throws IOException {
        if (!FileExistsMode.APPEND.equals((Object)this.fileExistsMode) && !FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode) && StringUtils.hasText((String)this.temporaryFileSuffix)) {
            this.renameTo(fileToWriteTo, resultFile);
        }
        if (this.deleteSourceFiles && originalFile != null) {
            originalFile.delete();
        }
        this.setPermissions(resultFile);
    }

    protected void setPermissions(File resultFile) throws IOException {
        if (this.permissions != null) {
            Files.setPosixFilePermissions(resultFile.toPath(), this.permissions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renameTo(File tempFile, File resultFile) throws IOException {
        Assert.notNull((Object)resultFile, (String)"'resultFile' must not be null");
        Assert.notNull((Object)tempFile, (String)"'tempFile' must not be null");
        if (resultFile.exists()) {
            if (!resultFile.setWritable(true, false) || !resultFile.delete()) throw new IOException("Failed to rename file '" + tempFile.getAbsolutePath() + "' to '" + resultFile.getAbsolutePath() + "' since '" + resultFile.getName() + "' is not writable or can not be deleted");
            FileWritingMessageHandler.rename(tempFile, resultFile);
            return;
        } else {
            FileWritingMessageHandler.rename(tempFile, resultFile);
        }
    }

    private File evaluateDestinationDirectoryExpression(Message<?> message) {
        File destinationDirectory = ExpressionUtils.expressionToFile((Expression)this.destinationDirectoryExpression, (EvaluationContext)this.evaluationContext, message, (String)"Destination Directory");
        this.validateDestinationDirectory(destinationDirectory, this.autoCreateDirectory);
        return destinationDirectory;
    }

    private synchronized FileState getFileState(File fileToWriteTo, boolean isString) throws FileNotFoundException {
        FileState state;
        String absolutePath = fileToWriteTo.getAbsolutePath();
        boolean appendNoFlush = FileExistsMode.APPEND_NO_FLUSH.equals((Object)this.fileExistsMode);
        if (appendNoFlush) {
            state = this.fileStates.get(absolutePath);
            if (state != null && (isString && state.stream != null || !isString && state.writer != null)) {
                state.close();
                state = null;
                this.fileStates.remove(absolutePath);
            }
            if (state == null) {
                state = isString ? new FileState(this.createWriter(fileToWriteTo, true), this.lockRegistry.obtain((Object)fileToWriteTo.getAbsolutePath())) : new FileState(this.createOutputStream(fileToWriteTo, true), this.lockRegistry.obtain((Object)fileToWriteTo.getAbsolutePath()));
                this.fileStates.put(absolutePath, state);
            }
            state.lastWrite = Long.MAX_VALUE;
        } else {
            state = null;
        }
        return state;
    }

    protected BufferedWriter createWriter(File fileToWriteTo, boolean append) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWriteTo, append), this.charset), this.bufferSize);
    }

    protected BufferedOutputStream createOutputStream(File fileToWriteTo, boolean append) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(fileToWriteTo, append), this.bufferSize);
    }

    public void trigger(Message<?> message) {
        this.flushIfNeeded(this.flushPredicate, message);
    }

    public synchronized void flushIfNeeded(FlushPredicate flushPredicate) {
        Iterator<Map.Entry<String, FileState>> iterator = this.fileStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FileState> entry = iterator.next();
            FileState state = entry.getValue();
            if (!flushPredicate.shouldFlush(entry.getKey(), state.firstWrite, state.lastWrite)) continue;
            iterator.remove();
            state.close();
        }
    }

    public synchronized void flushIfNeeded(MessageFlushPredicate flushPredicate, Message<?> filterMessage) {
        Iterator<Map.Entry<String, FileState>> iterator = this.fileStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FileState> entry = iterator.next();
            FileState state = entry.getValue();
            if (!flushPredicate.shouldFlush(entry.getKey(), state.firstWrite, state.lastWrite, filterMessage)) continue;
            iterator.remove();
            state.close();
        }
    }

    private synchronized void clearState(File fileToWriteTo, FileState state) {
        if (state != null) {
            this.fileStates.remove(fileToWriteTo.getAbsolutePath());
        }
    }

    private static void rename(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static final class DefaultFlushPredicate
    implements MessageFlushPredicate {
        DefaultFlushPredicate() {
        }

        @Override
        public boolean shouldFlush(String fileAbsolutePath, long firstWrite, long lastWrite, Message<?> triggerMessage) {
            Pattern pattern;
            if (triggerMessage.getPayload() instanceof String) {
                pattern = Pattern.compile((String)triggerMessage.getPayload());
            } else if (triggerMessage.getPayload() instanceof Pattern) {
                pattern = (Pattern)triggerMessage.getPayload();
            } else {
                throw new IllegalArgumentException("Invalid payload type, must be a String or Pattern");
            }
            return pattern.matcher(fileAbsolutePath).matches();
        }
    }

    @FunctionalInterface
    public static interface MessageFlushPredicate {
        public boolean shouldFlush(String var1, long var2, long var4, Message<?> var6);
    }

    @FunctionalInterface
    public static interface FlushPredicate {
        public boolean shouldFlush(String var1, long var2, long var4);
    }

    private final class Flusher
    implements Runnable {
        Flusher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileWritingMessageHandler fileWritingMessageHandler = FileWritingMessageHandler.this;
            synchronized (fileWritingMessageHandler) {
                long expired = FileWritingMessageHandler.this.flushTask == null ? Long.MAX_VALUE : System.currentTimeMillis() - FileWritingMessageHandler.this.flushInterval;
                Iterator iterator = FileWritingMessageHandler.this.fileStates.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    FileState state = (FileState)entry.getValue();
                    if (state.lastWrite >= expired && (FileWritingMessageHandler.this.flushWhenIdle || state.firstWrite >= expired)) continue;
                    iterator.remove();
                    state.close();
                    if (!FileWritingMessageHandler.this.logger.isDebugEnabled()) continue;
                    FileWritingMessageHandler.this.logger.debug((Object)("Flushed: " + (String)entry.getKey()));
                }
            }
        }
    }

    private static final class FileState {
        private final BufferedWriter writer;
        private final BufferedOutputStream stream;
        private final Lock lock;
        private final long firstWrite = System.currentTimeMillis();
        private volatile long lastWrite;

        FileState(BufferedWriter writer, Lock lock) {
            this.writer = writer;
            this.stream = null;
            this.lock = lock;
        }

        FileState(BufferedOutputStream stream, Lock lock) {
            this.writer = null;
            this.stream = stream;
            this.lock = lock;
        }

        private void close() {
            block8: {
                try {
                    this.lock.lockInterruptibly();
                    try {
                        if (this.writer != null) {
                            this.writer.close();
                            break block8;
                        }
                        this.stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }
}

