/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.feed.inbound;

import com.rometools.fetcher.FeedFetcher;
import com.rometools.fetcher.FetcherEvent;
import com.rometools.fetcher.FetcherListener;
import com.rometools.fetcher.impl.HashMapFeedInfoCache;
import com.rometools.fetcher.impl.HttpURLFeedFetcher;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FeedEntryMessageSource
extends IntegrationObjectSupport
implements MessageSource<SyndEntry> {
    private final URL feedUrl;
    private final FeedFetcher feedFetcher;
    private final Queue<SyndEntry> entries = new ConcurrentLinkedQueue<SyndEntry>();
    private final String metadataKey;
    private volatile MetadataStore metadataStore;
    private volatile long lastTime = -1L;
    private volatile boolean initialized;
    private final Object monitor = new Object();
    private final Comparator<SyndEntry> syndEntryComparator = new SyndEntryPublishedDateComparator();
    private final Object feedMonitor = new Object();

    public FeedEntryMessageSource(URL feedUrl, String metadataKey) {
        this(feedUrl, metadataKey, (FeedFetcher)new HttpURLFeedFetcher(HashMapFeedInfoCache.getInstance()));
    }

    public FeedEntryMessageSource(URL feedUrl, String metadataKey, FeedFetcher feedFetcher) {
        Assert.notNull((Object)feedUrl, (String)"feedUrl must not be null");
        Assert.notNull((Object)metadataKey, (String)"metadataKey must not be null");
        Assert.notNull((Object)feedFetcher, (String)"feedFetcher must not be null");
        this.feedUrl = feedUrl;
        this.metadataKey = metadataKey + "." + this.feedUrl;
        this.feedFetcher = feedFetcher;
    }

    public void setMetadataStore(MetadataStore metadataStore) {
        Assert.notNull((Object)metadataStore, (String)"metadataStore must not be null");
        this.metadataStore = metadataStore;
    }

    public String getComponentType() {
        return "feed:inbound-channel-adapter";
    }

    public Message<SyndEntry> receive() {
        Assert.isTrue((boolean)this.initialized, (String)"'FeedEntryReaderMessageSource' must be initialized before it can produce Messages.");
        SyndEntry entry = this.doReceive();
        if (entry == null) {
            return null;
        }
        return this.getMessageBuilderFactory().withPayload((Object)entry).build();
    }

    protected void onInit() throws Exception {
        String lastTimeValue;
        this.feedFetcher.addFetcherEventListener((FetcherListener)new FeedQueueUpdatingFetcherListener());
        if (this.metadataStore == null) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.metadataStore = IntegrationContextUtils.getMetadataStore((BeanFactory)beanFactory);
            }
            if (this.metadataStore == null) {
                this.metadataStore = new SimpleMetadataStore();
            }
        }
        if (StringUtils.hasText((String)(lastTimeValue = this.metadataStore.get(this.metadataKey)))) {
            this.lastTime = Long.parseLong(lastTimeValue);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyndEntry doReceive() {
        SyndEntry nextEntry = null;
        Object object = this.monitor;
        synchronized (object) {
            nextEntry = this.getNextEntry();
            if (nextEntry == null) {
                this.populateEntryList();
                nextEntry = this.getNextEntry();
            }
        }
        return nextEntry;
    }

    private SyndEntry getNextEntry() {
        SyndEntry next = this.entries.poll();
        if (next == null) {
            return null;
        }
        Date lastModifiedDate = FeedEntryMessageSource.getLastModifiedDate(next);
        this.lastTime = lastModifiedDate != null ? lastModifiedDate.getTime() : ++this.lastTime;
        this.metadataStore.put(this.metadataKey, this.lastTime + "");
        return next;
    }

    private void populateEntryList() {
        List retrievedEntries;
        SyndFeed syndFeed = this.getFeed();
        if (syndFeed != null && !CollectionUtils.isEmpty((Collection)(retrievedEntries = syndFeed.getEntries()))) {
            boolean withinNewEntries = false;
            Collections.sort(retrievedEntries, this.syndEntryComparator);
            for (SyndEntry entry : retrievedEntries) {
                Date entryDate = FeedEntryMessageSource.getLastModifiedDate(entry);
                if ((entryDate == null || entryDate.getTime() <= this.lastTime) && (entryDate != null || !withinNewEntries)) continue;
                this.entries.add(entry);
                withinNewEntries = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyndFeed getFeed() {
        SyndFeed feed = null;
        try {
            Object object = this.feedMonitor;
            synchronized (object) {
                feed = this.feedFetcher.retrieveFeed(this.feedUrl);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("retrieved feed at url '" + this.feedUrl + "'"));
                }
                if (feed == null && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"no feeds updated, returning null");
                }
            }
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve feed at url '" + this.feedUrl + "'", (Throwable)e);
        }
        return feed;
    }

    private static Date getLastModifiedDate(SyndEntry entry) {
        return entry.getUpdatedDate() != null ? entry.getUpdatedDate() : entry.getPublishedDate();
    }

    private class FeedQueueUpdatingFetcherListener
    implements FetcherListener {
        private FeedQueueUpdatingFetcherListener() {
        }

        public void fetcherEvent(FetcherEvent event) {
            String eventType = event.getEventType();
            if ("FEED_POLLED".equals(eventType)) {
                if (FeedEntryMessageSource.this.logger.isDebugEnabled()) {
                    FeedEntryMessageSource.this.logger.debug((Object)("\tEVENT: Feed Polled. URL = " + event.getUrlString()));
                }
            } else if ("FEED_UNCHANGED".equals(eventType) && FeedEntryMessageSource.this.logger.isDebugEnabled()) {
                FeedEntryMessageSource.this.logger.debug((Object)("\tEVENT: Feed Unchanged. URL = " + event.getUrlString()));
            }
        }
    }

    private static class SyndEntryPublishedDateComparator
    implements Comparator<SyndEntry> {
        private SyndEntryPublishedDateComparator() {
        }

        @Override
        public int compare(SyndEntry entry1, SyndEntry entry2) {
            Date date1 = FeedEntryMessageSource.getLastModifiedDate(entry1);
            Date date2 = FeedEntryMessageSource.getLastModifiedDate(entry2);
            if (date1 != null && date2 != null) {
                return date1.compareTo(date2);
            }
            if (date1 == null && date2 == null) {
                return 0;
            }
            return date2 == null ? 1 : 0;
        }
    }
}

