/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.amqp.channel.AbstractAmqpChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;

abstract class AbstractSubscribableAmqpChannel
extends AbstractAmqpChannel
implements SubscribableChannel,
SmartLifecycle,
DisposableBean {
    private final String channelName;
    private final AbstractMessageListenerContainer container;
    private volatile AbstractDispatcher dispatcher;
    private final boolean isPubSub;
    private volatile Integer maxSubscribers;
    private final AmqpAdmin admin;
    private final ConnectionFactory connectionFactory;

    protected AbstractSubscribableAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        this(channelName, container, amqpTemplate, false);
    }

    protected AbstractSubscribableAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        this(channelName, container, amqpTemplate, false, outboundMapper, inboundMapper);
    }

    protected AbstractSubscribableAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate, boolean isPubSub) {
        super(amqpTemplate);
        Assert.notNull((Object)container, (String)"container must not be null");
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
        this.container = container;
        this.isPubSub = isPubSub;
        this.connectionFactory = container.getConnectionFactory();
        this.admin = new RabbitAdmin(this.connectionFactory);
    }

    protected AbstractSubscribableAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate, boolean isPubSub, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        super(amqpTemplate, outboundMapper, inboundMapper);
        Assert.notNull((Object)container, (String)"container must not be null");
        Assert.hasText((String)channelName, (String)"channel name must not be empty");
        this.channelName = channelName;
        this.container = container;
        this.isPubSub = isPubSub;
        this.connectionFactory = container.getConnectionFactory();
        this.admin = new RabbitAdmin(this.connectionFactory);
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
        if (this.dispatcher != null) {
            this.dispatcher.setMaxSubscribers(this.maxSubscribers.intValue());
        }
    }

    protected AmqpAdmin getAdmin() {
        return this.admin;
    }

    protected ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public boolean subscribe(MessageHandler handler) {
        return this.dispatcher.addHandler(handler);
    }

    public boolean unsubscribe(MessageHandler handler) {
        return this.dispatcher.removeHandler(handler);
    }

    public void onInit() throws Exception {
        super.onInit();
        this.dispatcher = this.createDispatcher();
        if (this.maxSubscribers == null) {
            this.maxSubscribers = (Integer)this.getIntegrationProperty(this.isPubSub ? "spring.integration.channels.maxBroadcastSubscribers" : "spring.integration.channels.maxUnicastSubscribers", Integer.class);
        }
        this.setMaxSubscribers(this.maxSubscribers);
        String queue = this.obtainQueueName(this.admin, this.channelName);
        this.container.setQueueNames(new String[]{queue});
        SimpleMessageConverter converter = this.getAmqpTemplate() instanceof RabbitTemplate ? ((RabbitTemplate)this.getAmqpTemplate()).getMessageConverter() : new SimpleMessageConverter();
        DispatchingMessageListener listener = new DispatchingMessageListener((MessageConverter)converter, (MessageDispatcher)this.dispatcher, this, this.isPubSub, this.getMessageBuilderFactory(), this.getInboundHeaderMapper());
        this.container.setMessageListener((MessageListener)listener);
        if (!this.container.isActive()) {
            this.container.afterPropertiesSet();
        }
    }

    public boolean isAutoStartup() {
        return this.container != null && this.container.isAutoStartup();
    }

    public int getPhase() {
        return this.container != null ? this.container.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.container != null && this.container.isRunning();
    }

    public void start() {
        if (this.container != null) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.container != null) {
            this.container.stop(callback);
        }
    }

    public void destroy() throws Exception {
        if (this.container != null) {
            this.container.destroy();
        }
    }

    protected abstract AbstractDispatcher createDispatcher();

    protected abstract String obtainQueueName(AmqpAdmin var1, String var2);

    private static final class DispatchingMessageListener
    implements MessageListener {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final MessageDispatcher dispatcher;
        private final MessageConverter converter;
        private final AbstractSubscribableAmqpChannel channel;
        private final boolean isPubSub;
        private final MessageBuilderFactory messageBuilderFactory;
        private final AmqpHeaderMapper inboundHeaderMapper;

        private DispatchingMessageListener(MessageConverter converter, MessageDispatcher dispatcher, AbstractSubscribableAmqpChannel channel, boolean isPubSub, MessageBuilderFactory messageBuilderFactory, AmqpHeaderMapper inboundHeaderMapper) {
            Assert.notNull((Object)converter, (String)"MessageConverter must not be null");
            Assert.notNull((Object)dispatcher, (String)"MessageDispatcher must not be null");
            this.converter = converter;
            this.dispatcher = dispatcher;
            this.channel = channel;
            this.isPubSub = isPubSub;
            this.messageBuilderFactory = messageBuilderFactory;
            this.inboundHeaderMapper = inboundHeaderMapper;
        }

        public void onMessage(org.springframework.amqp.core.Message message) {
            Message<Object> messageToSend = null;
            try {
                Object converted = this.converter.fromMessage(message);
                if (converted != null) {
                    messageToSend = converted instanceof Message ? (Message<Object>)converted : this.buildMessage(message, converted);
                    this.dispatcher.dispatch(messageToSend);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"MessageConverter returned null, no Message to dispatch");
                }
            }
            catch (MessageDispatchingException e) {
                String exceptionMessage = e.getMessage() + " for amqp-channel '" + this.channel.getFullChannelName() + "'.";
                if (this.isPubSub) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)exceptionMessage, (Throwable)e);
                    }
                }
                throw new MessageDeliveryException(messageToSend, exceptionMessage, (Throwable)e);
            }
        }

        protected Message<Object> buildMessage(org.springframework.amqp.core.Message message, Object converted) {
            AbstractIntegrationMessageBuilder messageBuilder = this.messageBuilderFactory.withPayload(converted);
            if (this.channel.isExtractPayload()) {
                Map headers = this.inboundHeaderMapper.toHeadersFromRequest(message.getMessageProperties());
                messageBuilder.copyHeaders(headers);
            }
            return messageBuilder.build();
        }
    }
}

