/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.framework;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.nativex.substitutions.WithAot;

@TargetClass(className="org.springframework.boot.SpringApplication", onlyWith={WithAot.class, OnlyIfPresent.class})
final class Target_SpringApplication {
    Target_SpringApplication() {
    }

    @Substitute
    private <T> Collection<T> getSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, Object ... args) {
        ClassLoader classLoader = this.getClassLoader();
        LinkedHashSet<String> names = new LinkedHashSet<String>(SpringFactoriesLoader.loadFactoryNames(type, (ClassLoader)classLoader));
        List<T> instances = args.length == 0 ? SpringFactoriesLoader.loadFactories(type, (ClassLoader)classLoader) : this.createSpringFactoriesInstances(type, parameterTypes, classLoader, args, names);
        AnnotationAwareOrderComparator.sort((List)instances);
        return instances;
    }

    @Alias
    public ClassLoader getClassLoader() {
        return null;
    }

    @Alias
    private <T> List<T> createSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, ClassLoader classLoader, Object[] args, Set<String> names) {
        return null;
    }
}

