/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.logback;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.conditional.Condition;
import ch.qos.logback.core.joran.conditional.PropertyWrapperForScripts;
import ch.qos.logback.core.spi.PropertyContainer;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.nativex.substitutions.JaninoIsAround;
import org.springframework.nativex.substitutions.LogbackIsAround;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.nativex.substitutions.RemoveXmlSupport;

@TargetClass(className="ch.qos.logback.core.joran.conditional.PropertyEvalScriptBuilder", onlyWith={OnlyIfPresent.class, LogbackIsAround.class, JaninoIsAround.class, RemoveXmlSupport.class})
final class Target_PropertyEvalScriptBuilder {
    @Alias
    PropertyContainer localPropContainer;
    @Alias
    Context context;

    Target_PropertyEvalScriptBuilder() {
    }

    @Substitute
    public Condition build(String script) throws IllegalArgumentException {
        Matcher m = AllowedExpressionWrapper.ALLOWED_EXPRESSION_PATTERN.matcher(script);
        if (m.matches()) {
            String function = m.group(1);
            String field = m.group(2);
            switch (function) {
                case "isDefined": {
                    IsDefinedCondition definedCondition = new IsDefinedCondition(field);
                    definedCondition.setPropertyContainers(this.localPropContainer, (PropertyContainer)this.context);
                    return definedCondition;
                }
                case "isNull": {
                    IsNullCondition nullCondition = new IsNullCondition(field);
                    nullCondition.setPropertyContainers(this.localPropContainer, (PropertyContainer)this.context);
                    return nullCondition;
                }
            }
            throw new IllegalArgumentException(script);
        }
        throw new IllegalArgumentException("Only simple 'isDefined' and 'isNull' conditions are supported in native image: " + script);
    }

    private static class IsNullCondition
    extends PropertyWrapperForScripts
    implements Condition {
        private final String field;

        public IsNullCondition(String field) {
            this.field = field;
        }

        public boolean evaluate() {
            return this.isNull(this.field);
        }
    }

    private static class IsDefinedCondition
    extends PropertyWrapperForScripts
    implements Condition {
        private final String field;

        public IsDefinedCondition(String field) {
            this.field = field;
        }

        public boolean evaluate() {
            return this.isDefined(this.field);
        }
    }

    private static class AllowedExpressionWrapper {
        static final Pattern ALLOWED_EXPRESSION_PATTERN = Pattern.compile("\\s*(isDefined|isNull)\\s*\\(\\s*\"(([^\"]|\\\\)*)\"\\s*\\)\\s*");

        private AllowedExpressionWrapper() {
        }
    }
}

