/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.hint;

public class ProxyBits {
    public static final int NONE = 0;
    public static final int EXPOSE_PROXY = 1;
    public static final int IS_STATIC = 2;
    public static final int IS_FROZEN = 4;
    public static final int IS_OPAQUE = 8;
    private int value;

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object that) {
        if (that instanceof ProxyBits) {
            return this.value == ((ProxyBits)that).value;
        }
        return false;
    }

    public String toString() {
        return ProxyBits.toString(this.value);
    }

    public ProxyBits() {
        this.value = 0;
    }

    public ProxyBits(int value) {
        this.value = value;
    }

    public static final ProxyBits forValue(int value) {
        return new ProxyBits(value);
    }

    public static final ProxyBits forBits(int ... bits) {
        int value = 0;
        for (int i = 0; i < bits.length; ++i) {
            value |= bits[i];
        }
        return new ProxyBits(value);
    }

    public ProxyBits with(ProxyBits accessRequired) {
        return ProxyBits.forValue(this.value | accessRequired.value);
    }

    public static String toString(Integer value) {
        StringBuilder s = new StringBuilder();
        s.append("PBS(");
        if ((value & 2) != 0) {
            s.append("IS_STATIC ");
        }
        if ((value & 1) != 0) {
            s.append("EXPOSE_PROXY ");
        }
        if ((value & 4) != 0) {
            s.append("IS_FROZEN ");
        }
        if ((value & 8) != 0) {
            s.append("IS_OPAQUE ");
        }
        if (value == 0) {
            s.append("NONE");
        }
        return s.toString().trim() + ")";
    }

    public int getValue() {
        return this.value;
    }

    public static boolean isSet(int value, int mask) {
        return (value & mask) != 0;
    }
}

