/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.context.bootstrap.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aot.context.bootstrap.generator.infrastructure.nativex.NativeConfigurationRegistry;
import org.springframework.aot.test.context.bootstrap.generator.AotTestContextProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.nativex.hint.TypeAccess;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextBootstrapper;

class TestContextConfigurationDescriptor {
    private final Class<? extends TestContextBootstrapper> testContextBootstrapperType;
    private final MergedContextConfiguration contextConfiguration;
    private final AotTestContextProcessor aotTestContextProcessor;
    private final List<Class<?>> testClasses;

    TestContextConfigurationDescriptor(Class<? extends TestContextBootstrapper> testContextBootstrapperType, MergedContextConfiguration configuration, AotTestContextProcessor aotTestContextProcessor) {
        this.testContextBootstrapperType = testContextBootstrapperType;
        this.contextConfiguration = configuration;
        this.aotTestContextProcessor = aotTestContextProcessor;
        this.testClasses = new ArrayList();
        this.testClasses.add(configuration.getTestClass());
    }

    GenericApplicationContext parseTestContext() {
        return this.aotTestContextProcessor.prepareTestContext(this.contextConfiguration);
    }

    void contributeNativeConfiguration(NativeConfigurationRegistry nativeConfigurationRegistry) {
        nativeConfigurationRegistry.reflection().forType(this.testContextBootstrapperType).withAccess(new TypeAccess[]{TypeAccess.DECLARED_CONSTRUCTORS});
    }

    CodeBlock writeTestContextLoaderInstanceSupplier(ClassName className) {
        return this.aotTestContextProcessor.writeInstanceSupplier(this.contextConfiguration, className);
    }

    boolean isSameContext(MergedContextConfiguration config) {
        return this.contextConfiguration.equals((Object)config);
    }

    void registerTestClass(Class<?> testClass) {
        this.testClasses.add(testClass);
    }

    MergedContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    List<Class<?>> getTestClasses() {
        return this.testClasses;
    }
}

