/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.config.JsonSchemaFormat;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.json.JacksonMetadata;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class PersistentEntityToJsonSchemaConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor SCHEMA_TYPE = TypeDescriptor.valueOf(JsonSchema.class);
    private static final TypeInformation<?> STRING_TYPE_INFORMATION = ClassTypeInformation.from(String.class);
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
    private final ResourceMappings mappings;
    private final PersistentEntities entities;
    private final MessageSourceAccessor accessor;
    private final ObjectMapper objectMapper;
    private final RepositoryRestConfiguration configuration;

    public PersistentEntityToJsonSchemaConverter(PersistentEntities entities, ResourceMappings mappings, MessageSourceAccessor accessor, ObjectMapper objectMapper, RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)accessor, (String)"MessageSourceAccessor must not be null!");
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null!");
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.entities = entities;
        this.mappings = mappings;
        this.accessor = accessor;
        this.objectMapper = objectMapper;
        this.configuration = configuration;
        for (TypeInformation domainType : entities.getManagedTypes()) {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(domainType.getType(), JsonSchema.class));
        }
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Class.class.isAssignableFrom(sourceType.getType()) && JsonSchema.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public JsonSchema convert(Class<?> domainType) {
        return this.convert(domainType, STRING_TYPE, SCHEMA_TYPE);
    }

    public JsonSchema convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        PersistentEntity persistentEntity = this.entities.getPersistentEntity((Class)source);
        ResourceMetadata metadata = this.mappings.getMetadataFor(persistentEntity.getType());
        JsonSchema.Descriptors descriptors = new JsonSchema.Descriptors();
        List<JsonSchema.JsonSchemaProperty<?>> propertiesFor = this.getPropertiesFor(persistentEntity.getType(), metadata, descriptors);
        return new JsonSchema(persistentEntity.getName(), this.resolveMessage((MessageSourceResolvable)metadata.getItemResourceDescription()), propertiesFor, descriptors);
    }

    private List<JsonSchema.JsonSchemaProperty<?>> getPropertiesFor(Class<?> type, ResourceMetadata metadata, JsonSchema.Descriptors descriptors) {
        PersistentEntity entity = this.entities.getPersistentEntity(type);
        JacksonMetadata jackson = new JacksonMetadata(this.objectMapper, type);
        AssociationLinks associationLinks = new AssociationLinks(this.mappings);
        if (entity == null) {
            return Collections.emptyList();
        }
        ArrayList properties = new ArrayList();
        for (BeanPropertyDefinition definition : jackson) {
            PersistentProperty persistentProperty = entity.getPersistentProperty(definition.getInternalName());
            TypeInformation propertyType = persistentProperty == null ? ClassTypeInformation.from((Class)definition.getPrimaryMember().getRawType()) : persistentProperty.getTypeInformation();
            Class rawPropertyType = propertyType.getType();
            JsonSchemaFormat format = this.configuration.metadataConfiguration().getSchemaFormatFor(rawPropertyType);
            ResourceDescription description = persistentProperty == null ? jackson.getFallbackDescription(definition) : this.getDescriptionFor(persistentProperty, metadata);
            JsonSchema.Property property = this.getSchemaProperty(definition, propertyType, description);
            if (persistentProperty != null && !persistentProperty.isWritable()) {
                property = (JsonSchema.Property)property.withReadOnly();
            }
            if (format != null) {
                properties.add(property.with(format));
                continue;
            }
            Pattern pattern = this.configuration.metadataConfiguration().getPatternFor(rawPropertyType);
            if (pattern != null) {
                properties.add(property.with(pattern));
                continue;
            }
            if (jackson.isValueType()) {
                properties.add(property.with(STRING_TYPE_INFORMATION));
                continue;
            }
            if (persistentProperty == null) {
                properties.add(property);
                continue;
            }
            if (persistentProperty.isIdProperty() && !this.configuration.isIdExposedFor(rawPropertyType)) continue;
            if (associationLinks.isLinkableAssociation(persistentProperty)) {
                properties.add(property.with(JsonSchemaFormat.URI));
                continue;
            }
            if (persistentProperty.isEntity()) {
                if (!descriptors.hasDescriptorFor(propertyType)) {
                    descriptors.addDescriptor(propertyType, new JsonSchema.Item(propertyType, this.getNestedPropertiesFor(persistentProperty, descriptors)));
                }
                properties.add(property.with(propertyType, JsonSchema.Descriptors.getReference(propertyType)));
                continue;
            }
            properties.add(property.with(propertyType));
        }
        return properties;
    }

    private Collection<JsonSchema.JsonSchemaProperty<?>> getNestedPropertiesFor(PersistentProperty<?> property, JsonSchema.Descriptors descriptors) {
        if (!property.isEntity()) {
            return Collections.emptyList();
        }
        return this.getPropertiesFor(property.getActualType(), this.mappings.getMetadataFor(property.getActualType()), descriptors);
    }

    private JsonSchema.Property getSchemaProperty(BeanPropertyDefinition definition, TypeInformation<?> type, ResourceDescription description) {
        String name = definition.getName();
        String resolvedDescription = this.resolveMessage((MessageSourceResolvable)description);
        boolean required = definition.isRequired();
        Class rawType = type.getType();
        if (!rawType.isEnum()) {
            return new JsonSchema.Property(name, resolvedDescription, required);
        }
        return new JsonSchema.EnumProperty(name, rawType, description.getDefaultMessage().equals(resolvedDescription) ? null : resolvedDescription, required);
    }

    private ResourceDescription getDescriptionFor(PersistentProperty<?> property, ResourceMetadata metadata) {
        ResourceMapping propertyMapping = metadata.getMappingFor(property);
        return propertyMapping.getDescription();
    }

    private String resolveMessage(MessageSourceResolvable resolvable) {
        if (resolvable == null) {
            return null;
        }
        try {
            return this.accessor.getMessage(resolvable);
        }
        catch (NoSuchMessageException o_O) {
            if (this.configuration.metadataConfiguration().omitUnresolvableDescriptionKeys()) {
                return null;
            }
            throw o_O;
        }
    }
}

