/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.data.rest.webmvc.mapping.LinkCollectingAssociationHandler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.UriTemplate;
import org.springframework.util.Assert;

public class PersistentEntityJackson2Module
extends SimpleModule {
    private static final long serialVersionUID = -7289265674870906323L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJackson2Module.class);
    private static final TypeDescriptor URI_DESCRIPTOR = TypeDescriptor.valueOf(URI.class);

    public PersistentEntityJackson2Module(ResourceMappings mappings, PersistentEntities entities, RepositoryRestConfiguration config, UriToEntityConverter converter, EntityLinks entityLinks) {
        super(new Version(2, 0, 0, null, "org.springframework.data.rest", "jackson-module"));
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)entities, (String)"Repositories must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null!");
        AssociationLinks associationLinks = new AssociationLinks(mappings);
        LinkCollector collector = new LinkCollector(entities, entityLinks, associationLinks);
        this.addSerializer((JsonSerializer)new PersistentEntityResourceSerializer(collector));
        this.addSerializer((JsonSerializer)new ProjectionSerializer(collector, mappings));
        this.addSerializer((JsonSerializer)new ProjectionResourceContentSerializer());
        this.setSerializerModifier(new AssociationOmittingSerializerModifier(entities, associationLinks, config));
        this.setDeserializerModifier(new AssociationUriResolvingDeserializerModifier(entities, converter, associationLinks));
    }

    private static class CollectionValueInstantiator
    extends ValueInstantiator {
        private final PersistentProperty<?> property;

        public CollectionValueInstantiator(PersistentProperty<?> property) {
            Assert.notNull(property, (String)"Property must not be null!");
            Assert.isTrue((property.isCollectionLike() || property.isMap() ? 1 : 0) != 0, (String)"Property must be a collection or map property!");
            this.property = property;
        }

        public String getValueTypeDesc() {
            return this.property.getType().getName();
        }

        public Object createUsingDefault(DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Class collectionOrMapType = this.property.getType();
            return this.property.isMap() ? CollectionFactory.createMap((Class)collectionOrMapType, (int)0) : CollectionFactory.createCollection((Class)collectionOrMapType, (int)0);
        }
    }

    private static class LinkCollector {
        private final PersistentEntities entities;
        private final AssociationLinks associationLinks;
        private final EntityLinks links;

        public LinkCollector(PersistentEntities entities, EntityLinks entityLinks, AssociationLinks associationLinks) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
            Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
            Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
            this.links = entityLinks;
            this.entities = entities;
            this.associationLinks = associationLinks;
        }

        public Links getLinksFor(Object object) {
            return this.getLinksFor(object, Collections.<Link>emptyList());
        }

        public Links getLinksFor(Object object, List<Link> existingLinks) {
            Assert.notNull((Object)object, (String)"Object must not be null!");
            Assert.notNull(existingLinks, (String)"Existing links must not be null!");
            PersistentEntity entity = this.entities.getPersistentEntity(object.getClass());
            Links links = new Links(existingLinks);
            Link selfLink = this.createSelfLink(object, entity, links);
            if (selfLink == null) {
                return links;
            }
            Path path = new Path(selfLink.expand(new Object[0]).getHref());
            LinkCollectingAssociationHandler handler = new LinkCollectingAssociationHandler(this.entities, path, this.associationLinks);
            entity.doWithAssociations((SimpleAssociationHandler)handler);
            ArrayList<Link> result = new ArrayList<Link>(existingLinks);
            result.addAll(handler.getLinks());
            return this.addSelfLinkIfNecessary(object, entity, result);
        }

        private Links addSelfLinkIfNecessary(Object object, PersistentEntity<?, ?> entity, List<Link> existing) {
            Links result = new Links(existing);
            if (result.hasLink("self")) {
                return result;
            }
            ArrayList<Link> list = new ArrayList<Link>();
            list.add(this.createSelfLink(object, entity, result));
            list.addAll(existing);
            return new Links(list);
        }

        private Link createSelfLink(Object object, PersistentEntity<?, ?> entity, Links existing) {
            if (existing.hasLink("self")) {
                return existing.getLink("self");
            }
            IdentifierAccessor accessor = entity.getIdentifierAccessor(object);
            Object identifier = accessor.getIdentifier();
            if (identifier == null) {
                return null;
            }
            return this.links.linkToSingleResource(entity.getType(), identifier).withSelfRel();
        }
    }

    private static class ProjectionResourceContentSerializer
    extends StdSerializer<ProjectionResourceContent> {
        private boolean unwrapping;

        public ProjectionResourceContentSerializer() {
            super(ProjectionResourceContent.class);
        }

        public void serialize(ProjectionResourceContent value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            provider.findValueSerializer(value.getProjectionInterface(), null).unwrappingSerializer(null).serialize(value.getProjection(), jgen, provider);
        }

        public boolean isUnwrappingSerializer() {
            return this.unwrapping;
        }

        public JsonSerializer<ProjectionResourceContent> unwrappingSerializer(NameTransformer unwrapper) {
            this.unwrapping = true;
            return this;
        }
    }

    static class ProjectionResourceContent {
        private final Object projection;
        private final Class<?> projectionInterface;

        public ProjectionResourceContent(Object projection, Class<?> projectionInterface) {
            this.projection = projection;
            this.projectionInterface = projectionInterface;
        }

        public Object getProjection() {
            return this.projection;
        }

        public Class<?> getProjectionInterface() {
            return this.projectionInterface;
        }
    }

    static class ProjectionResource
    extends Resource<ProjectionResourceContent> {
        ProjectionResource(TargetAware projection, Iterable<Link> links) {
            super((Object)new ProjectionResourceContent(projection, projection.getClass().getInterfaces()[0]), links);
        }
    }

    static class ProjectionSerializer
    extends StdSerializer<TargetAware> {
        private final LinkCollector collector;
        private final ResourceMappings mappings;
        private boolean unwrapping;

        public ProjectionSerializer(LinkCollector collector, ResourceMappings mappings) {
            super(TargetAware.class);
            this.collector = collector;
            this.mappings = mappings;
        }

        public void serialize(TargetAware value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            Object target = value.getTarget();
            Links links = this.mappings.getMetadataFor(value.getTargetClass()).isExported() ? this.collector.getLinksFor(target) : new Links(new Link[0]);
            jgen.writeStartObject();
            provider.findValueSerializer(ProjectionResource.class, null).unwrappingSerializer(null).serialize((Object)new ProjectionResource(value, (Iterable<Link>)links), jgen, provider);
            jgen.writeEndObject();
        }

        public boolean isUnwrappingSerializer() {
            return this.unwrapping;
        }

        public JsonSerializer<TargetAware> unwrappingSerializer(NameTransformer unwrapper) {
            this.unwrapping = true;
            return this;
        }
    }

    static class UriStringDeserializer
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = -2175900204153350125L;
        private final PersistentProperty<?> property;
        private final UriToEntityConverter converter;

        public UriStringDeserializer(PersistentProperty<?> property, UriToEntityConverter converter) {
            super(property.getActualType());
            this.property = property;
            this.converter = converter;
        }

        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            URI uri = new UriTemplate(jp.getValueAsString()).expand(new Object[0]);
            TypeDescriptor typeDescriptor = TypeDescriptor.valueOf((Class)this.property.getActualType());
            return this.converter.convert((Object)uri, URI_DESCRIPTOR, typeDescriptor);
        }
    }

    public static class AssociationUriResolvingDeserializerModifier
    extends BeanDeserializerModifier {
        private final UriToEntityConverter converter;
        private final PersistentEntities repositories;
        private final AssociationLinks associationLinks;

        public AssociationUriResolvingDeserializerModifier(PersistentEntities repositories, UriToEntityConverter converter, AssociationLinks associationLinks) {
            Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
            Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null!");
            Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
            this.repositories = repositories;
            this.converter = converter;
            this.associationLinks = associationLinks;
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            Iterator properties = builder.getProperties();
            PersistentEntity entity = this.repositories.getPersistentEntity(beanDesc.getBeanClass());
            if (entity == null) {
                return builder;
            }
            while (properties.hasNext()) {
                SettableBeanProperty property = (SettableBeanProperty)properties.next();
                PersistentProperty persistentProperty = entity.getPersistentProperty(property.getName());
                if (!this.associationLinks.isLinkableAssociation(persistentProperty)) continue;
                UriStringDeserializer uriStringDeserializer = new UriStringDeserializer(persistentProperty, this.converter);
                if (persistentProperty.isCollectionLike()) {
                    CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(persistentProperty.getType(), persistentProperty.getActualType());
                    CollectionValueInstantiator instantiator = new CollectionValueInstantiator(persistentProperty);
                    CollectionDeserializer collectionDeserializer = new CollectionDeserializer((JavaType)collectionType, (JsonDeserializer)uriStringDeserializer, null, (ValueInstantiator)instantiator);
                    builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)collectionDeserializer), false);
                    continue;
                }
                builder.addOrReplaceProperty(property.withValueDeserializer((JsonDeserializer)uriStringDeserializer), false);
            }
            return builder;
        }
    }

    static class AssociationOmittingSerializerModifier
    extends BeanSerializerModifier {
        private final PersistentEntities entities;
        private final RepositoryRestConfiguration configuration;
        private final AssociationLinks associationLinks;

        public AssociationOmittingSerializerModifier(PersistentEntities entities, AssociationLinks associationLinks, RepositoryRestConfiguration configuration) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
            Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
            Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
            this.entities = entities;
            this.configuration = configuration;
            this.associationLinks = associationLinks;
        }

        public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
            PersistentEntity entity = this.entities.getPersistentEntity(beanDesc.getBeanClass());
            if (entity == null) {
                return builder;
            }
            ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
            for (BeanPropertyWriter writer : builder.getProperties()) {
                PersistentProperty<?> persistentProperty = this.findProperty(writer.getName(), entity, beanDesc);
                if (persistentProperty == null) {
                    result.add(writer);
                    continue;
                }
                if (this.associationLinks.isLinkableAssociation(persistentProperty) || persistentProperty.isIdProperty() && !this.configuration.isIdExposedFor(entity.getType()) || persistentProperty.isVersionProperty()) continue;
                result.add(writer);
            }
            builder.setProperties(result);
            return builder;
        }

        private PersistentProperty<?> findProperty(String finalName, PersistentEntity<?, ?> entity, BeanDescription description) {
            for (BeanPropertyDefinition definition : description.findProperties()) {
                if (!definition.getName().equals(finalName)) continue;
                return entity.getPersistentProperty(definition.getInternalName());
            }
            return null;
        }
    }

    private static class PersistentEntityResourceSerializer
    extends StdSerializer<PersistentEntityResource> {
        private final LinkCollector collector;

        private PersistentEntityResourceSerializer(LinkCollector collector) {
            super(PersistentEntityResource.class);
            this.collector = collector;
        }

        public void serialize(final PersistentEntityResource resource, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            Object content;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serializing PersistentEntity " + resource.getPersistentEntity());
            }
            if (TargetAware.class.isInstance(content = resource.getContent())) {
                TargetAware targetAware = (TargetAware)content;
                Links links = this.collector.getLinksFor(targetAware.getTarget(), resource.getLinks());
                provider.defaultSerializeValue((Object)new ProjectionResource(targetAware, (Iterable<Link>)links), jgen);
                return;
            }
            Links links = this.collector.getLinksFor(resource.getContent(), resource.getLinks());
            Resource<Object> resourceToRender = new Resource<Object>(resource.getContent(), (Iterable)links){

                @JsonUnwrapped
                public Resources<?> getEmbedded() {
                    return resource.getEmbeddeds();
                }
            };
            provider.defaultSerializeValue((Object)resourceToRender, jgen);
        }
    }
}

