/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RepositoryRestController
class RepositorySchemaController {
    private static final String BASE_MAPPING = "/{repository}";
    private final PersistentEntityToJsonSchemaConverter jsonSchemaConverter;

    @Autowired
    public RepositorySchemaController(PersistentEntityToJsonSchemaConverter jsonSchemaConverter) {
        Assert.notNull((Object)jsonSchemaConverter, (String)"PersistentEntityToJsonSchemaConverter must not be null!");
        this.jsonSchemaConverter = jsonSchemaConverter;
    }

    @RequestMapping(value={"/{repository}/schema"}, method={RequestMethod.GET})
    public HttpEntity<JsonSchema> schema(RootResourceInformation resourceInformation) {
        JsonSchema schema = this.jsonSchemaConverter.convert(resourceInformation.getDomainType());
        return new ResponseEntity((Object)schema, HttpStatus.OK);
    }
}

